/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newproject;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.sdk.operation.project.template.EmptyTemplateOperation;
import org.eclipse.scout.sdk.operation.project.template.IScoutProjectTemplateOperation;
import org.eclipse.scout.sdk.operation.project.template.OutlineTemplateOperation;
import org.eclipse.scout.sdk.operation.project.template.SingleFormTemplateOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.internal.wizard.AbstractWizardPage;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizard;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScoutProjectTemplateWizardPage
extends AbstractWizardPage {
    private FilteredTable m_table;
    private IScoutProjectTemplateOperation m_selectedTemplate;
    private Label m_descriptionLabel;
    private P_ContentProvider m_provider;

    public ScoutProjectTemplateWizardPage() {
        super(ScoutProjectTemplateWizardPage.class.getName());
        this.setTitle("Scout application templates");
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_table = new FilteredTable(parent, 68100);
        this.m_table.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IScoutProjectTemplateOperation selectedItem = null;
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    selectedItem = (IScoutProjectTemplateOperation)selection.getFirstElement();
                }
                ScoutProjectTemplateWizardPage.this.handleSelection(selectedItem);
            }
        });
        this.m_provider = new P_ContentProvider();
        this.m_table.getViewer().setLabelProvider((IBaseLabelProvider)this.m_provider);
        this.m_table.getViewer().setContentProvider((IContentProvider)this.m_provider);
        this.m_table.getViewer().setInput((Object)this.m_provider);
        this.m_descriptionLabel = new Label(parent, 80);
        this.refreshDefaultSelection();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_table.setLayoutData(new GridData(768));
        this.m_descriptionLabel.setLayoutData((Object)new GridData(768));
    }

    public void refreshList() {
        this.m_table.refresh(true);
        this.refreshDefaultSelection();
    }

    private void refreshDefaultSelection() {
        this.m_table.getViewer().setSelection((ISelection)new StructuredSelection((Object)this.m_provider.getDefaultOperation()));
        this.m_descriptionLabel.setText(this.m_provider.getDefaultOperation().getDescription());
    }

    private void handleSelection(IScoutProjectTemplateOperation selectedItem) {
        this.m_selectedTemplate = selectedItem;
        if (this.isControlCreated()) {
            String description = "";
            if (this.m_selectedTemplate != null) {
                description = this.m_selectedTemplate.getDescription();
            }
            this.m_descriptionLabel.setText(description);
        }
    }

    public IScoutProjectTemplateOperation getSelectedTemplate() {
        return this.m_selectedTemplate;
    }

    public ScoutProjectNewWizard getWizard() {
        return (ScoutProjectNewWizard)super.getWizard();
    }

    public void performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws IllegalArgumentException, CoreException {
        this.m_selectedTemplate.run(monitor, workingCopyManager);
    }

    private class P_ContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private IScoutProjectTemplateOperation[] m_templates;
        private IScoutProjectTemplateOperation m_defaultOperation;

        public P_ContentProvider() {
            this.refresh();
        }

        private void refresh() {
            ArrayList<Object> elements = new ArrayList<Object>();
            EmptyTemplateOperation emptyTemplate = new EmptyTemplateOperation();
            elements.add(emptyTemplate);
            this.m_defaultOperation = emptyTemplate;
            ScoutProjectNewWizardPage previousPage = (ScoutProjectNewWizardPage)ScoutProjectTemplateWizardPage.this.getWizard().getPage(ScoutProjectNewWizardPage.class.getName());
            if (previousPage.isCreateClient()) {
                OutlineTemplateOperation outlineTemplate = new OutlineTemplateOperation();
                elements.add(outlineTemplate);
                SingleFormTemplateOperation singleFormTemplate = new SingleFormTemplateOperation();
                elements.add(singleFormTemplate);
                this.m_defaultOperation = singleFormTemplate;
            }
            this.m_templates = elements.toArray(new IScoutProjectTemplateOperation[elements.size()]);
        }

        public Object[] getElements(Object inputElement) {
            this.refresh();
            return this.m_templates;
        }

        public String getColumnText(Object element, int columnIndex) {
            IScoutProjectTemplateOperation op = (IScoutProjectTemplateOperation)element;
            return op.getTemplateName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ScoutSdkUi.getImage("folder_open.gif");
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public IScoutProjectTemplateOperation getDefaultOperation() {
            return this.m_defaultOperation;
        }
    }
}

