/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.type;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;

public class PackageContentChangedListener
implements IElementChangedListener {
    public static final int CHANGED_FLAG_MASK = 1050427;
    private final IPage m_page;
    private IPackageFragment m_pck;

    public PackageContentChangedListener(IPage page, IPackageFragment pck) {
        this.m_page = page;
        this.m_pck = pck;
    }

    public final void elementChanged(ElementChangedEvent event) {
        this.visitDelta(event.getDelta(), event.getType());
    }

    private void visitDelta(IJavaElementDelta delta, int eventType) {
        int flags = delta.getFlags();
        int kind = delta.getKind();
        if ((flags & 8) != 0) {
            IJavaElementDelta[] childDeltas = delta.getAffectedChildren();
            if (childDeltas != null && childDeltas.length > 0) {
                int i = 0;
                while (i < childDeltas.length) {
                    this.visitDelta(childDeltas[i], eventType);
                    ++i;
                }
            }
        } else {
            IJavaElement e = delta.getElement();
            if (e != null) {
                switch (e.getElementType()) {
                    case 5: {
                        ICompilationUnit icu;
                        IJavaElement parent;
                        if (kind == 2 && (parent = (icu = (ICompilationUnit)e).getParent()).getElementType() == 4 && parent.equals(this.m_pck)) {
                            this.m_page.markStructureDirty();
                        }
                        break;
                    }
                    case 7: {
                        this.handleTypeChanged((IType)e, flags, kind);
                        break;
                    }
                    case 4: {
                        this.getPage().markStructureDirty();
                    }
                }
            }
        }
    }

    protected void handleTypeChanged(IType type, int flags, int kind) {
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                if (!type.getPackageFragment().equals(this.m_pck)) break;
                this.getPage().markStructureDirty();
            }
        }
    }

    public IPage getPage() {
        return this.m_page;
    }
}

