/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.extensions.IPageFactory;
import org.eclipse.scout.sdk.ui.internal.extensions.ExplorerPageExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.INodeVisitor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPageFilter;
import org.eclipse.scout.sdk.ui.view.outline.pages.PageDirtyListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.PageFilter;
import org.eclipse.scout.sdk.workspace.IScoutElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractPage
implements IPage {
    private String m_name;
    private ArrayList<IPage> m_children;
    private IPage m_parent;
    private boolean m_recursive;
    private boolean m_childrenLoaded;
    private int m_quality;
    private PageDirtyListener m_pageDirtyListener = new PageDirtyListener(this);
    private PageFilter m_cachedPageFilter;
    private ImageDescriptor m_imageDesc;
    private String m_textColorId;
    private IPageFilter m_pageFilter;

    public AbstractPage() {
        this.m_children = new ArrayList();
    }

    @Override
    public void setParent(IPage parent) {
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.addChild(this);
        }
    }

    @Override
    public IPage getParent() {
        return this.m_parent;
    }

    @Override
    public IScoutElement getScoutResource() {
        if (this.getParent() != null) {
            return this.getParent().getScoutResource();
        }
        return null;
    }

    @Override
    public ScoutExplorerPart getOutlineView() {
        IPage parent = this.getParent();
        if (parent != null) {
            return parent.getOutlineView();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String s) {
        this.m_name = s;
    }

    @Override
    public boolean isChildrenLoaded() {
        return this.m_childrenLoaded;
    }

    @Override
    public boolean isInitiallyLoaded() {
        return false;
    }

    @Override
    public void markStructureDirty() {
        ScoutExplorerPart o = this.getOutlineView();
        if (o != null) {
            o.markStructureDirty(this);
        }
    }

    public String getDecoratedName() {
        return String.valueOf(this.getName()) + (this.m_recursive ? " (R)" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(IPage child) {
        if (child == null) {
            throw new IllegalArgumentException("adding null child to " + this.getName());
        }
        ArrayList<IPage> arrayList = this.m_children;
        synchronized (arrayList) {
            this.m_children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(IPage childPage) {
        if (childPage == null) {
            throw new IllegalArgumentException("remove null child to " + this.getName());
        }
        childPage.setParent(null);
        ArrayList<IPage> arrayList = this.m_children;
        synchronized (arrayList) {
            return this.m_children.remove(childPage);
        }
    }

    @Override
    public IPage[] getChildArray() {
        return this.getChildArray(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPage[] getChildArray(IPageFilter filter) {
        ArrayList<IPage> children = new ArrayList<IPage>();
        ArrayList<IPage> arrayList = this.m_children;
        synchronized (arrayList) {
            for (IPage p : this.m_children) {
                if (filter != null && !filter.accept(p)) continue;
                children.add(p);
            }
        }
        return children.toArray(new IPage[children.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IPage> getChildren() {
        ArrayList<IPage> arrayList = this.m_children;
        synchronized (arrayList) {
            return Collections.unmodifiableList(new ArrayList<IPage>(this.m_children));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren() {
        ArrayList<IPage> arrayList = this.m_children;
        synchronized (arrayList) {
            return this.m_children.size() > 0;
        }
    }

    @Override
    public void unloadPage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unloadChildren() {
        ArrayList<IPage> arrayList = this.m_children;
        synchronized (arrayList) {
            for (IPage page : this.m_children) {
                page.setParent(null);
                page.unloadChildren();
                page.unloadPage();
            }
            this.m_children.clear();
            this.m_childrenLoaded = false;
        }
    }

    @Override
    public void refresh(boolean clearCache) {
        ScoutExplorerPart outlineView = this.getOutlineView();
        if (outlineView != null) {
            outlineView.markStructureDirty(this);
        }
    }

    public String toString() {
        return this.getDecoratedName();
    }

    @Override
    public final void loadChildren() {
        this.loadChildrenImpl();
        ExplorerPageExtensionPoint.ExplorerPageExtension[] extensions = ExplorerPageExtensionPoint.getExtensions(this);
        if (extensions != null) {
            ExplorerPageExtensionPoint.ExplorerPageExtension[] explorerPageExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                ExplorerPageExtensionPoint.ExplorerPageExtension ext = explorerPageExtensionArray[n2];
                if (ext.getFactoryClass() != null) {
                    IPageFactory factory = ext.createFactoryClass();
                    factory.createChildren(this);
                } else if (ext.getPageClass() != null) {
                    IPage childPage = ext.createPageInstance();
                    childPage.setParent(this);
                }
                ++n2;
            }
        }
        this.m_childrenLoaded = true;
    }

    protected void loadChildrenImpl() {
    }

    public void refreshFilteredChildren() {
        ScoutExplorerPart o = this.getOutlineView();
        if (o != null) {
            o.markFilterChanged(this);
        }
    }

    public final PageDirtyListener getPageDirtyListener() {
        return this.m_pageDirtyListener;
    }

    public void fillContextMenu(IMenuManager manager) {
        Action ra;
        Action na = this.createNewAction();
        if (na != null) {
            manager.add((IAction)na);
        }
        manager.add((IContributionItem)new Separator());
        Action ea = this.createEditAction();
        if (ea != null) {
            manager.add((IAction)ea);
        }
        if ((ra = this.createRenameAction()) != null) {
            manager.add((IAction)ra);
        }
        manager.add((IContributionItem)new Separator());
        Action da = this.createDeleteAction();
        if (da != null) {
            manager.add((IAction)da);
        }
    }

    @Override
    public void setImageDescriptor(ImageDescriptor desc) {
        this.m_imageDesc = desc;
    }

    public ImageDescriptor getBaseImageDescriptor() {
        if (this.m_imageDesc == null) {
            this.m_imageDesc = this.isFolder() ? ScoutSdkUi.getImageDescriptor("folder_open.gif") : ScoutSdkUi.getImageDescriptor("default.gif");
        }
        return this.m_imageDesc;
    }

    public final Image getImage() {
        ImageDescriptor baseDesc = this.getBaseImageDescriptor();
        int flags = 0;
        Point size = new Point(16, 16);
        int quality = this.getQuality();
        switch (quality) {
            case 2: {
                flags |= 0x40;
                break;
            }
            case 1: {
                flags |= 0x20;
            }
        }
        JavaElementImageDescriptor desc = new JavaElementImageDescriptor(baseDesc, flags, size);
        return ScoutSdkUi.getImage((CompositeImageDescriptor)desc);
    }

    @Override
    public int getQuality() {
        if (this.hasChildren()) {
            IPage[] a = this.getChildArray();
            int q = 0;
            int i = 0;
            while (i < a.length) {
                if ((q = Math.max(q, a[i].getQuality())) == 2) break;
                ++i;
            }
            return q;
        }
        return 0;
    }

    public Action createNewAction() {
        return null;
    }

    public Action createRenameAction() {
        return null;
    }

    public Action createDeleteAction() {
        return null;
    }

    public Action createEditAction() {
        return null;
    }

    public Action createMoveAction(int moveOperation) {
        return null;
    }

    public void handleSelectionDelegate() {
    }

    public boolean handleDoubleClickedDelegate() {
        return false;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public int accept(INodeVisitor visitor) {
        switch (visitor.visit(this)) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                this.visitChildren(visitor);
                return 0;
            }
        }
        return this.visitChildren(visitor);
    }

    private int visitChildren(INodeVisitor visitor) {
        if (!this.isChildrenLoaded()) {
            this.loadChildren();
        }
        for (IPage childPage : this.getChildren()) {
            switch (childPage.accept(visitor)) {
                case 0: {
                    return 0;
                }
            }
        }
        return 1;
    }
}

