/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.util.ScoutSourceUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractScoutTypePage
extends AbstractPage
implements ITypePage {
    private IType m_type;
    private int m_nodeTypeIndex = -1;

    @Override
    public void setType(IType type) {
        this.m_type = type;
        String methodNameForTranslatedText = this.getMethodNameForTranslatedText();
        this.setName(ScoutSourceUtilities.getTranslatedMethodStringValue((IType)this.getType(), (String)methodNameForTranslatedText));
    }

    @Override
    public IType getType() {
        return this.m_type;
    }

    protected String getMethodNameForTranslatedText() {
        return null;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public int getQuality() {
        int quality = 0;
        if (this.getType().exists()) {
            quality = ScoutSeverityManager.getInstance().getSeverityOf((Object)this.getType());
        }
        return quality;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ShowJavaReferencesAction((IJavaElement)this.getType()));
    }

    @Override
    public boolean handleDoubleClickedDelegate() {
        try {
            ITextEditor textEditor;
            IRegion reg;
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)this.getType());
            if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
            }
            return true;
        }
        catch (Exception ex) {
            ScoutSdkUi.logWarning(ex);
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractScoutTypePage)) {
            return false;
        }
        AbstractScoutTypePage page = (AbstractScoutTypePage)obj;
        return this.getType().equals(page.getType()) && CompareUtility.equals((Object)page.getParent(), (Object)this.getParent());
    }
}

