/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.jdt.JdtEvent;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;

public class InnerTypeOrderChangedPageDirtyListener
implements IJavaResourceChangedListener {
    private final IPage m_page;
    private final IType m_innerTypeSuperType;
    private final IType m_declaringType;

    public InnerTypeOrderChangedPageDirtyListener(IPage page, IType innerTypeSuperType, IType declaringType) {
        this.m_page = page;
        this.m_innerTypeSuperType = innerTypeSuperType;
        this.m_declaringType = declaringType;
    }

    public void handleEvent(JdtEvent event) {
        if (TypeUtility.exists((IJavaElement)event.getElement()) && event.getElementType() == 16) {
            IAnnotation annotation = (IAnnotation)event.getElement();
            IJavaElement annotationOwner = annotation.getParent();
            ITypeHierarchy superTypeHierarchy = event.getSuperTypeHierarchy();
            if (superTypeHierarchy != null && superTypeHierarchy.contains(this.getInnerTypeSuperType()) && TypeUtility.exists((IJavaElement)annotationOwner) && annotationOwner.getParent().equals(this.getDeclaringType())) {
                this.getPage().markStructureDirty();
            }
        }
    }

    public IPage getPage() {
        return this.m_page;
    }

    public IType getInnerTypeSuperType() {
        return this.m_innerTypeSuperType;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }
}

