/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.jdt.JdtEvent;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;

public class InnerTypePageDirtyListener
implements IJavaResourceChangedListener {
    private final IPage m_page;
    private final IType m_superType;

    public InnerTypePageDirtyListener(IPage page, IType superType) {
        this.m_page = page;
        this.m_superType = superType;
    }

    public IPage getPage() {
        return this.m_page;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void handleEvent(JdtEvent event) {
        ITypePage page = null;
        for (IPage p : this.getPage().getChildren()) {
            if (!(p instanceof ITypePage) || !((ITypePage)p).getType().equals(event.getElement())) continue;
            page = (ITypePage)p;
            break;
        }
        if (page != null && (event.getEventType() == 2 || event.getEventType() == 1)) {
            this.handleChildPagesChanged(event);
            return;
        }
        ITypeHierarchy superTypeHierarchy = event.getSuperTypeHierarchy();
        if (superTypeHierarchy != null) {
            if (page != null) {
                if (!superTypeHierarchy.contains(this.getSuperType())) {
                    this.handleChildPagesChanged(event);
                    return;
                }
            } else if (superTypeHierarchy.contains(this.getSuperType())) {
                this.handleChildPagesChanged(event);
            }
        }
    }

    protected void handleChildPagesChanged(JdtEvent event) {
        this.getPage().markStructureDirty();
    }
}

