/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty;

import java.util.Comparator;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.jdt.JdtEvent;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty.BeanPropertyNodePage;
import org.eclipse.scout.sdk.ui.wizard.beanproperty.BeanPropertyNewWizard;
import org.eclipse.scout.sdk.workspace.member.IPropertyBean;
import org.eclipse.scout.sdk.workspace.type.IPropertyBeanFilter;
import org.eclipse.scout.sdk.workspace.type.PropertyBeanComparators;
import org.eclipse.scout.sdk.workspace.type.PropertyBeanFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;

public class BeanPropertyTablePage
extends AbstractPage {
    private final IType m_declaringType;
    private P_MethodChangedListener m_methodChangedListener;

    public BeanPropertyTablePage(IPage parentPage, IType beanDeclaringType) {
        this.m_declaringType = beanDeclaringType;
        this.setName(Texts.get((String)"BeanPropertyTablePage"));
        this.setParent(parentPage);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("variables.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_methodChangedListener != null) {
            ScoutSdk.removeMethodChangedListener((IType)this.getDeclaringType(), (IJavaResourceChangedListener)this.m_methodChangedListener);
        }
        super.unloadPage();
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.BeanPropertyTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public void loadChildrenImpl() {
        IPropertyBean[] beans;
        if (this.m_methodChangedListener == null) {
            this.m_methodChangedListener = new P_MethodChangedListener();
            ScoutSdk.addMethodChangedListener((IType)this.getDeclaringType(), (IJavaResourceChangedListener)this.m_methodChangedListener);
        }
        IPropertyBean[] iPropertyBeanArray = beans = TypeUtility.getPropertyBeans((IType)this.getDeclaringType(), (IPropertyBeanFilter)PropertyBeanFilters.getFormDataPropertyFilter(), (Comparator)PropertyBeanComparators.getNameComparator());
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyBean bean = iPropertyBeanArray[n2];
            new BeanPropertyNodePage(this, bean);
            ++n2;
        }
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Property Bean"}), ScoutSdkUi.getImageDescriptor("variable_add.png"), (IWizard)new BeanPropertyNewWizard(this.m_declaringType));
    }

    private class P_MethodChangedListener
    implements IJavaResourceChangedListener {
        private P_MethodChangedListener() {
        }

        public void handleEvent(JdtEvent event) {
            if (TypeUtility.hasAnnotation((IAnnotatable)((IAnnotatable)event.getElement()), (String)"org.eclipse.scout.commons.annotations.FormData")) {
                BeanPropertyTablePage.this.markStructureDirty();
            }
        }
    }
}

