/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service;

import java.util.Comparator;
import java.util.TreeMap;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.jdt.JdtEvent;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.AxisWebServiceProviderPublishAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.ServiceOperationNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.wizard.services.ServiceOperationNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.IMethodFilter;
import org.eclipse.scout.sdk.workspace.type.MethodComparators;
import org.eclipse.scout.sdk.workspace.type.MethodFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;

public abstract class AbstractServiceNodePage
extends AbstractScoutTypePage {
    private final IType m_interfaceType;
    private P_ServiceMethodsListener m_serviceMethodListener;

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public AbstractServiceNodePage(AbstractPage parent, IType type, IType interfaceType) {
        this.setParent(parent);
        this.setType(type);
        this.m_interfaceType = interfaceType;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("service.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_serviceMethodListener != null) {
            ScoutSdk.removeMethodChangedListener((IType)this.getType(), (IJavaResourceChangedListener)this.m_serviceMethodListener);
            this.m_serviceMethodListener = null;
        }
        super.unloadPage();
    }

    @Override
    public void loadChildrenImpl() {
        int n;
        int n2;
        IMethod[] iMethodArray;
        if (this.m_interfaceType == null) {
            return;
        }
        if (this.m_serviceMethodListener == null) {
            this.m_serviceMethodListener = new P_ServiceMethodsListener();
            ScoutSdk.addMethodChangedListener((IType)this.getType(), (IJavaResourceChangedListener)this.m_serviceMethodListener);
        }
        IMethod[] serviceMethods = TypeUtility.getMethods((IType)this.getType(), (IMethodFilter)MethodFilters.getFlagsFilter((int)1), (Comparator)MethodComparators.getNameComparator());
        TreeMap<String, IMethod> interfaceMethodsMap = new TreeMap<String, IMethod>();
        if (TypeUtility.exists((IJavaElement)this.getInterfaceType())) {
            iMethodArray = TypeUtility.getMethods((IType)this.getType(), (IMethodFilter)MethodFilters.getFlagsFilter((int)1), (Comparator)MethodComparators.getNameComparator());
            n2 = iMethodArray.length;
            n = 0;
            while (n < n2) {
                IMethod m = iMethodArray[n];
                interfaceMethodsMap.put(m.getElementName(), m);
                ++n;
            }
        }
        iMethodArray = serviceMethods;
        n2 = serviceMethods.length;
        n = 0;
        while (n < n2) {
            IMethod implMethod = iMethodArray[n];
            new ServiceOperationNodePage(this, (IMethod)interfaceMethodsMap.get(implMethod.getElementName()), implMethod);
            ++n;
        }
    }

    @Override
    public Action createDeleteAction() {
        Action deleteAction = super.createDeleteAction();
        if (deleteAction != null) {
            deleteAction.setImageDescriptor(ScoutSdkUi.getImageDescriptor("service_remove.png"));
        }
        return deleteAction;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IAction)new WizardAction("New Service Operation...", ScoutSdkUi.getImageDescriptor("serviceOperation_add.png"), (IWizard)new ServiceOperationNewWizard(this.getInterfaceType(), new IType[]{this.getType()})));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new AxisWebServiceProviderPublishAction(this.getOutlineView().getSite().getShell(), this.getType(), this.getInterfaceType()));
        manager.add((IAction)new FormDataSqlBindingValidateAction(this.getType()));
    }

    public IType getInterfaceType() {
        return this.m_interfaceType;
    }

    private class P_ServiceMethodsListener
    implements IJavaResourceChangedListener {
        private P_ServiceMethodsListener() {
        }

        public void handleEvent(JdtEvent event) {
            AbstractServiceNodePage.this.markStructureDirty();
        }
    }
}

