/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.multipage;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.scout.sdk.jdt.listener.ElementChangedListenerEx;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi.MultiBooleanPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi.MultiIntegerPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi.MultiLongPresenter;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.multipage.AbstractMultiPageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.multi.AbstractMultiMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyTypeSet;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethodSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class JdtTypeMultiPropertyPart
extends AbstractMultiPageSectionBasedViewPart {
    private static final String SECTION_ID_PROPERTIES = "section.properties";
    private IElementChangedListener m_methodChangedListener;
    private ConfigPropertyTypeSet m_configPropertyTypeSet;
    private HashMap<String, AbstractMultiMethodPresenter<?>> m_methodPresenters = new HashMap();
    private P_DelayedUpdateJob m_updateJob;

    @Override
    protected void createSections() {
        ArrayList<IType> types = new ArrayList<IType>();
        IPage[] iPageArray = this.getPages();
        int n = iPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPage p = iPageArray[n2];
            if (!(p instanceof AbstractScoutTypePage)) {
                return;
            }
            types.add(((AbstractScoutTypePage)p).getType());
            ++n2;
        }
        this.m_configPropertyTypeSet = new ConfigPropertyTypeSet(types.toArray(new IType[types.size()]));
        if (this.m_configPropertyTypeSet.hasConfigPropertyMethods()) {
            ISection propertySection = this.createSection(SECTION_ID_PROPERTIES, "Properties");
            ConfigurationMethodSet[] configurationMethodSetArray = this.m_configPropertyTypeSet.getCommonConfigPropertyMethodSets();
            int n3 = configurationMethodSetArray.length;
            n = 0;
            while (n < n3) {
                ConfigurationMethodSet set = configurationMethodSetArray[n];
                this.createConfigMethodPresenter(propertySection.getSectionClient(), set);
                ++n;
            }
        }
        super.createSections();
        if (this.m_updateJob == null) {
            this.m_updateJob = new P_DelayedUpdateJob(this.getForm().getDisplay());
        }
        if (this.m_methodChangedListener == null) {
            this.m_methodChangedListener = new P_MethodChangedListener2();
            JavaCore.addElementChangedListener((IElementChangedListener)this.m_methodChangedListener);
        }
    }

    @Override
    public void cleanup() {
        if (this.m_methodChangedListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_methodChangedListener);
            this.m_methodChangedListener = null;
        }
        if (this.m_updateJob != null) {
            this.m_updateJob.cancel();
            this.m_updateJob = null;
        }
    }

    protected AbstractMultiMethodPresenter createConfigMethodPresenter(Composite parent, ConfigurationMethodSet methodSet) {
        AbstractMultiMethodPresenter presenter = null;
        String propertyType = methodSet.getConfigAnnotationType();
        if (propertyType.equals("BOOLEAN")) {
            presenter = new MultiBooleanPresenter(this.getFormToolkit(), parent);
            presenter.setMethodSet(methodSet);
        } else if (!propertyType.equals("DOUBLE") && !propertyType.equals("DRAG_AND_DROP_TYPE")) {
            if (propertyType.equals("INTEGER")) {
                presenter = new MultiIntegerPresenter(this.getFormToolkit(), parent);
                presenter.setMethodSet(methodSet);
            } else if (propertyType.equals("LONG")) {
                presenter = new MultiLongPresenter(this.getFormToolkit(), parent);
                presenter.setMethodSet(methodSet);
            } else if (!(propertyType.equals("STRING") || propertyType.equals("FONT") || propertyType.equals("COLOR") || propertyType.equals("OBJECT") || propertyType.equals("BUTTON_DISPLAY_STYLE") || propertyType.equals("BUTTON_SYSTEM_TYPE") || propertyType.equals("CODE_TYPE") || propertyType.equals("COMPOSER_ATTRIBUTE_TYPE") || propertyType.equals("FILE_EXTENSIONS") || propertyType.equals("FORM_DISPLAY_HINT") || propertyType.equals("FORM_VIEW_ID") || propertyType.equals("HORIZONTAL_ALIGNMENT") || propertyType.equals("ICON_ID") || propertyType.equals("KEY_STROKE") || propertyType.equals("LOOKUP_CALL") || propertyType.equals("LOOKUP_SERVICE") || propertyType.equals("MASTER_FIELD") || propertyType.equals("OUTLINE_ROOT_PAGE") || propertyType.equals("OUTLINE") || propertyType.equals("OUTLINES") || propertyType.equals("FORM") || propertyType.equals("SEARCH_FORM") || propertyType.equals("NLS_PROVIDER") || propertyType.equals("SQL_STYLE") || propertyType.equals("SQL") || propertyType.equals("TEXT") || propertyType.equals("VERTICAL_ALIGNMENT") || propertyType.equals("CHART_QNAME") || propertyType.equals("HOUR_OF_DAY") || propertyType.equals("DURATION_MINUTES") || propertyType.equals("MENU_CLASS"))) {
                propertyType.equals("PRIMITIVE_TYPE");
            }
        }
        if (presenter != null) {
            GridData layoutData = new GridData(768);
            layoutData.widthHint = 200;
            presenter.getContainer().setLayoutData((Object)layoutData);
            this.m_methodPresenters.put(methodSet.getMethodName(), presenter);
        } else {
            ScoutSdkUi.logWarning("Could not find a presenter for property '" + propertyType + "'.");
        }
        return presenter;
    }

    private void handleMethodChanged(IMethod method) {
        AbstractMultiMethodPresenter<?> presenter;
        ConfigurationMethod updatedMethod;
        if (this.m_configPropertyTypeSet.isRelevantType(method.getDeclaringType()) && (updatedMethod = this.m_configPropertyTypeSet.updateIfChanged(method)) != null && (presenter = this.m_methodPresenters.get(updatedMethod.getMethodName())) != null) {
            this.m_updateJob.update(presenter, this.m_configPropertyTypeSet.getConfigurationMethodSet(updatedMethod.getMethodName()));
        }
    }

    private class P_DelayedUpdateJob
    extends Job {
        private Object m_delayedUpdateLock;
        private ConfigurationMethodSet m_methodSet;
        private AbstractMultiMethodPresenter m_presenter;
        private final Display m_display;

        public P_DelayedUpdateJob(Display display) {
            super("");
            this.m_delayedUpdateLock = new Object();
            this.m_display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(AbstractMultiMethodPresenter presenter, ConfigurationMethodSet methodSet) {
            Object object = this.m_delayedUpdateLock;
            synchronized (object) {
                this.cancel();
                this.setName("Update presenter for '" + methodSet.getMethodName() + "'...");
                this.m_presenter = presenter;
                this.m_methodSet = methodSet;
                this.schedule(200L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object object = this.m_delayedUpdateLock;
            synchronized (object) {
                this.m_display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P_DelayedUpdateJob.this.m_presenter.getContainer() != null && !P_DelayedUpdateJob.this.m_presenter.getContainer().isDisposed()) {
                            P_DelayedUpdateJob.this.m_presenter.setMethodSet(P_DelayedUpdateJob.this.m_methodSet);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        }
    }

    private class P_MethodChangedListener2
    extends ElementChangedListenerEx {
        private P_MethodChangedListener2() {
        }

        protected boolean visit(int kind, int flags, IJavaElement e, CompilationUnit ast) {
            if (e != null && e.getElementType() == 9) {
                JdtTypeMultiPropertyPart.this.handleMethodChanged((IMethod)e);
                return true;
            }
            return super.visit(kind, flags, e, ast);
        }
    }
}

