/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.scout.commons.RunnableWithData;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.jdt.JdtEvent;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.CompilationUnitSaveOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.ExecMethodPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.ExecResetSerchFilterMethodPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.PageFilterPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.BooleanPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.ButtonDisplayStylePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.ButtonSystemTypePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.CodeTypeProposalPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.ColorPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.DoublePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.FontPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.FormDisplayHintPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.FormViewIdPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.HorizontalAlignmentPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.IconPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.IntegerPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.LongPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.LookupCallProposalPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.LookupServiceProposalPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.MasterFieldPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.MultiLineStringPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.NlsTextPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.OutlineRootPagePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.OutlinesPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.PrimitiveTypePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.SearchFormPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.StringPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.VerticalAglinmentPresenter;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyType;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class JdtTypePropertyPart
extends AbstractSinglePageSectionBasedViewPart {
    protected static final String SECTION_ID_FILTER = "section.filter";
    protected static final String SECTION_ID_PROPERTIES = "section.properties";
    protected static final String SECTION_ID_OPERATIONS = "section.operations";
    private IJavaResourceChangedListener m_methodChangedListener;
    private ConfigPropertyType m_configPropertyType;
    private HashMap<String, AbstractMethodPresenter> m_methodPresenters;
    private HashMap<String, ConfigurationMethod> m_methodsToUpdate;
    private Object m_methodUpdateLock = new Object();
    private P_UpdateMethodsJob m_updateJob;
    private Button m_saveButton;
    private IStatus m_icuNotSyncStatus;
    private P_MarkDirtyJob m_markDirtyJob = new P_MarkDirtyJob();
    private Object m_markDirtyLock = new Object();

    public JdtTypePropertyPart() {
        this.m_methodsToUpdate = new HashMap();
        this.m_methodPresenters = new HashMap();
    }

    @Override
    public AbstractScoutTypePage getPage() {
        return (AbstractScoutTypePage)super.getPage();
    }

    @Override
    public void setPage(IPage page) {
        super.setPage(page);
        this.m_icuNotSyncStatus = new Status(1, "org.eclipse.scout.sdk.ui", "Save the file '" + this.getPage().getType().getResource().getName() + "' to use property view.");
    }

    @Override
    protected Control createHead(Composite parent) {
        Composite headArea = this.getFormToolkit().createComposite(parent);
        Hyperlink title = this.getFormToolkit().createHyperlink(headArea, this.getPage().getName(), 64);
        title.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    JavaUI.openInEditor((IJavaElement)JdtTypePropertyPart.this.getPage().getType());
                }
                catch (Exception e1) {
                    ScoutSdkUi.logError("could not open '" + JdtTypePropertyPart.this.getPage().getType().getElementName() + "' in editor.", e1);
                }
            }
        });
        this.m_saveButton = this.getFormToolkit().createButton(headArea, "Save file", 8);
        this.m_saveButton.setEnabled(false);
        this.m_saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICompilationUnit icu = JdtTypePropertyPart.this.getPage().getType().getCompilationUnit();
                if (icu.isWorkingCopy()) {
                    CompilationUnitSaveOperation op = new CompilationUnitSaveOperation(icu);
                    new OperationJob((IOperation)op).schedule();
                }
            }
        });
        headArea.setLayout((Layout)new GridLayout(2, false));
        GridData titleData = new GridData(800);
        title.setLayoutData((Object)titleData);
        this.m_saveButton.setLayoutData((Object)new GridData(896));
        return headArea;
    }

    @Override
    protected void createSections() {
        ConfigurationMethod[] operationPropertyMethods;
        int n;
        if (this.m_updateJob == null) {
            this.m_updateJob = new P_UpdateMethodsJob(this.getForm().getDisplay());
        }
        if (this.getPage().isFolder()) {
            ISection filterSection = this.createSection(SECTION_ID_FILTER, "Filter");
            PageFilterPresenter filterPresenter = new PageFilterPresenter(this.getFormToolkit(), filterSection.getSectionClient(), this.getPage());
            GridData layoutData = new GridData(768);
            layoutData.widthHint = 200;
            filterPresenter.getContainer().setLayoutData((Object)layoutData);
            this.getSection(SECTION_ID_FILTER).setExpanded(false);
        }
        this.m_configPropertyType = new ConfigPropertyType(this.getPage().getType());
        ConfigurationMethod[] configPropertyMethods = this.m_configPropertyType.getConfigurationMethods(ConfigurationMethod.PROPERTY_METHOD);
        if (configPropertyMethods != null && configPropertyMethods.length > 0) {
            ISection configPropertiesSection = this.createSection(SECTION_ID_PROPERTIES, "Properties");
            ConfigurationMethod[] configurationMethodArray = configPropertyMethods;
            n = configPropertyMethods.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurationMethod m = configurationMethodArray[n2];
                AbstractMethodPresenter presenter = null;
                presenter = this.createConfigMethodPresenter(configPropertiesSection.getSectionClient(), m);
                if (presenter != null) {
                    GridData layoutData = new GridData(768);
                    layoutData.widthHint = 200;
                    presenter.getContainer().setLayoutData((Object)layoutData);
                    this.m_methodPresenters.put(m.getMethodName(), presenter);
                }
                ++n2;
            }
        }
        if ((operationPropertyMethods = this.m_configPropertyType.getConfigurationMethods(ConfigurationMethod.OPERATION_METHOD)) != null && operationPropertyMethods.length > 0) {
            ISection operationPropertiesSection = this.createSection(SECTION_ID_OPERATIONS, "Operations");
            ConfigurationMethod[] configurationMethodArray = operationPropertyMethods;
            int n3 = operationPropertyMethods.length;
            n = 0;
            while (n < n3) {
                ConfigurationMethod m = configurationMethodArray[n];
                this.createOperationPresenter(operationPropertiesSection.getSectionClient(), m);
                ++n;
            }
        }
        if (this.m_methodChangedListener == null) {
            this.m_methodChangedListener = new P_MethodChangedListener();
            ScoutSdk.addJavaResourceChangedListener((IJavaResourceChangedListener)this.m_methodChangedListener);
        }
        try {
            this.setCompilationUnitDirty(this.getPage().getType().getCompilationUnit().isWorkingCopy() && this.getPage().getType().getCompilationUnit().getBuffer().hasUnsavedChanges());
        }
        catch (JavaModelException javaModelException) {
            ScoutSdkUi.logWarning("could not determ working copy '" + this.getPage().getType().getElementName() + "'.");
        }
    }

    @Override
    protected void cleanup() {
        if (this.m_methodChangedListener != null) {
            ScoutSdk.removeJavaResourceChangedListener((IJavaResourceChangedListener)this.m_methodChangedListener);
            this.m_methodChangedListener = null;
        }
    }

    protected AbstractMethodPresenter createConfigMethodPresenter(Composite parent, ConfigurationMethod method) {
        AbstractMethodPresenter presenter = null;
        String propertyType = method.getConfigAnnotationType();
        if (propertyType.equals("BOOLEAN")) {
            presenter = new BooleanPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if (propertyType.equals("DOUBLE")) {
            presenter = new DoublePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if (!propertyType.equals("DRAG_AND_DROP_TYPE")) {
            if (propertyType.equals("INTEGER")) {
                presenter = new IntegerPresenter(this.getFormToolkit(), parent);
                presenter.setMethod(method);
            } else if (propertyType.equals("LONG")) {
                presenter = new LongPresenter(this.getFormToolkit(), parent);
                presenter.setMethod(method);
            } else if (propertyType.equals("STRING")) {
                presenter = new StringPresenter(this.getFormToolkit(), parent);
                presenter.setMethod(method);
            } else if (propertyType.equals("FONT")) {
                presenter = new FontPresenter(this.getFormToolkit(), parent);
                presenter.setMethod(method);
            } else if (propertyType.equals("COLOR")) {
                presenter = new ColorPresenter(this.getFormToolkit(), parent);
                presenter.setMethod(method);
            } else if (!propertyType.equals("OBJECT")) {
                if (propertyType.equals("BUTTON_DISPLAY_STYLE")) {
                    presenter = new ButtonDisplayStylePresenter(this.getFormToolkit(), parent);
                    presenter.setMethod(method);
                } else if (propertyType.equals("BUTTON_SYSTEM_TYPE")) {
                    presenter = new ButtonSystemTypePresenter(this.getFormToolkit(), parent);
                    presenter.setMethod(method);
                } else if (propertyType.equals("CODE_TYPE")) {
                    presenter = new CodeTypeProposalPresenter(this.getFormToolkit(), parent);
                    presenter.setMethod(method);
                } else if (!propertyType.equals("COMPOSER_ATTRIBUTE_TYPE") && !propertyType.equals("FILE_EXTENSIONS")) {
                    if (propertyType.equals("FORM_DISPLAY_HINT")) {
                        presenter = new FormDisplayHintPresenter(this.getFormToolkit(), parent);
                        presenter.setMethod(method);
                    } else if (propertyType.equals("FORM_VIEW_ID")) {
                        presenter = new FormViewIdPresenter(this.getFormToolkit(), parent);
                        presenter.setMethod(method);
                    } else if (propertyType.equals("HORIZONTAL_ALIGNMENT")) {
                        presenter = new HorizontalAlignmentPresenter(this.getFormToolkit(), parent);
                        presenter.setMethod(method);
                    } else if (propertyType.equals("ICON_ID")) {
                        presenter = new IconPresenter(this.getFormToolkit(), parent);
                        presenter.setMethod(method);
                    } else if (!propertyType.equals("KEY_STROKE")) {
                        if (propertyType.equals("LOOKUP_CALL")) {
                            presenter = new LookupCallProposalPresenter(this.getFormToolkit(), parent);
                            presenter.setMethod(method);
                        } else if (propertyType.equals("LOOKUP_SERVICE")) {
                            presenter = new LookupServiceProposalPresenter(this.getFormToolkit(), parent);
                            presenter.setMethod(method);
                        } else if (propertyType.equals("MASTER_FIELD")) {
                            presenter = new MasterFieldPresenter(this.getFormToolkit(), parent);
                            presenter.setMethod(method);
                        } else if (propertyType.equals("OUTLINE_ROOT_PAGE")) {
                            presenter = new OutlineRootPagePresenter(this.getFormToolkit(), parent);
                            presenter.setMethod(method);
                        } else if (!propertyType.equals("OUTLINE")) {
                            if (propertyType.equals("OUTLINES")) {
                                presenter = new OutlinesPresenter(this.getFormToolkit(), parent);
                                presenter.setMethod(method);
                            } else if (!propertyType.equals("FORM")) {
                                if (propertyType.equals("SEARCH_FORM")) {
                                    presenter = new SearchFormPresenter(this.getFormToolkit(), parent);
                                    presenter.setMethod(method);
                                } else if (!propertyType.equals("NLS_PROVIDER") && !propertyType.equals("SQL_STYLE")) {
                                    if (propertyType.equals("SQL")) {
                                        presenter = new MultiLineStringPresenter(this.getFormToolkit(), parent);
                                        presenter.setMethod(method);
                                    } else if (propertyType.equals("TEXT")) {
                                        presenter = new NlsTextPresenter(this.getFormToolkit(), parent);
                                        presenter.setMethod(method);
                                    } else if (propertyType.equals("VERTICAL_ALIGNMENT")) {
                                        presenter = new VerticalAglinmentPresenter(this.getFormToolkit(), parent);
                                        presenter.setMethod(method);
                                    } else if (!(propertyType.equals("CHART_QNAME") || propertyType.equals("HOUR_OF_DAY") || propertyType.equals("DURATION_MINUTES") || propertyType.equals("MENU_CLASS") || !propertyType.equals("PRIMITIVE_TYPE"))) {
                                        presenter = new PrimitiveTypePresenter(this.getFormToolkit(), parent);
                                        presenter.setMethod(method);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (presenter != null) {
            GridData layoutData = new GridData(768);
            layoutData.widthHint = 200;
            presenter.getContainer().setLayoutData((Object)layoutData);
            this.m_methodPresenters.put(method.getMethodName(), presenter);
        } else {
            ScoutSdkUi.logWarning("Could not find a presenter for property '" + propertyType + "'.");
        }
        return presenter;
    }

    protected AbstractMethodPresenter createOperationPresenter(Composite parent, ConfigurationMethod method) {
        ExecMethodPresenter presenter = null;
        if (method.getMethodName().equals("execResetSearchFilter")) {
            presenter = new ExecResetSerchFilterMethodPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else {
            presenter = new ExecMethodPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        }
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
        this.m_methodPresenters.put(method.getMethodName(), presenter);
        return presenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMethodChanged(IMethod method) {
        ConfigurationMethod updatedMethod;
        if (this.m_configPropertyType.isRelevantType(method.getDeclaringType()) && (updatedMethod = this.m_configPropertyType.updateIfChanged(method)) != null) {
            Object object = this.m_methodUpdateLock;
            synchronized (object) {
                this.m_methodsToUpdate.put(updatedMethod.getMethodName(), updatedMethod);
                this.m_updateJob.cancel();
                this.m_updateJob.schedule(150L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompilationUnitDirty(final boolean dirty) {
        Object object = this.m_markDirtyLock;
        synchronized (object) {
            ScrolledForm form = this.getForm();
            if (form != null && !form.isDisposed()) {
                form.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (JdtTypePropertyPart.this.getForm() != null && !JdtTypePropertyPart.this.getForm().isDisposed()) {
                            JdtTypePropertyPart.this.m_saveButton.setEnabled(dirty);
                            for (AbstractMethodPresenter p : JdtTypePropertyPart.this.m_methodPresenters.values()) {
                                p.setEnabled(!dirty);
                            }
                            if (dirty) {
                                JdtTypePropertyPart.this.addStatus(JdtTypePropertyPart.this.m_icuNotSyncStatus);
                            } else {
                                JdtTypePropertyPart.this.removeStatus(JdtTypePropertyPart.this.m_icuNotSyncStatus);
                            }
                        }
                    }
                });
            }
        }
    }

    private class P_MarkDirtyJob
    extends Job {
        private boolean m_dirty;

        public P_MarkDirtyJob() {
            super("");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            JdtTypePropertyPart.this.setCompilationUnitDirty(this.m_dirty);
            return Status.OK_STATUS;
        }

        public void setDirty(boolean dirty) {
            this.m_dirty = dirty;
        }

        public boolean isDirty() {
            return this.m_dirty;
        }
    }

    private class P_MethodChangedListener
    implements IJavaResourceChangedListener {
        private P_MethodChangedListener() {
        }

        public void handleEvent(JdtEvent event) {
            switch (event.getEventType()) {
                case 1: 
                case 2: 
                case 4: {
                    if (event.getElement().getElementType() != 9) break;
                    JdtTypePropertyPart.this.handleMethodChanged((IMethod)event.getElement());
                    break;
                }
                case 10: {
                    if (event.getElementType() != 5 || !JdtTypePropertyPart.this.getPage().getType().getCompilationUnit().equals(event.getElement())) break;
                    JdtTypePropertyPart.this.m_markDirtyJob.cancel();
                    JdtTypePropertyPart.this.m_markDirtyJob.setDirty(true);
                    JdtTypePropertyPart.this.m_markDirtyJob.schedule(150L);
                    break;
                }
                case 11: {
                    if (event.getElementType() != 5 || !JdtTypePropertyPart.this.getPage().getType().getCompilationUnit().equals(event.getElement())) break;
                    JdtTypePropertyPart.this.m_markDirtyJob.cancel();
                    JdtTypePropertyPart.this.m_markDirtyJob.setDirty(false);
                    JdtTypePropertyPart.this.m_markDirtyJob.schedule(150L);
                }
            }
        }
    }

    private class P_UpdateMethodsJob
    extends Job {
        private final Display m_display;

        public P_UpdateMethodsJob(Display display) {
            super("");
            this.m_display = display;
            this.setSystem(true);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ConfigurationMethod[] methods = new ConfigurationMethod[]{};
            Object object = JdtTypePropertyPart.this.m_methodUpdateLock;
            synchronized (object) {
                if (JdtTypePropertyPart.this.m_methodsToUpdate.size() > 0) {
                    methods = JdtTypePropertyPart.this.m_methodsToUpdate.values().toArray(new ConfigurationMethod[JdtTypePropertyPart.this.m_methodsToUpdate.size()]);
                }
                JdtTypePropertyPart.this.m_methodsToUpdate.clear();
            }
            ConfigurationMethod[] configurationMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurationMethod cm = configurationMethodArray[n2];
                AbstractMethodPresenter presenter = (AbstractMethodPresenter)JdtTypePropertyPart.this.m_methodPresenters.get(cm.getMethodName());
                if (presenter != null) {
                    RunnableWithData runnable = new RunnableWithData(){

                        public void run() {
                            ((AbstractMethodPresenter)this.getData("presenter")).setMethod((ConfigurationMethod)this.getData("configMethod"));
                        }
                    };
                    runnable.setData("presenter", (Object)presenter);
                    runnable.setData("configMethod", (Object)cm);
                    if (this.m_display != null && !this.m_display.isDisposed()) {
                        this.m_display.syncExec((Runnable)runnable);
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }
}

