/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.ProductSelectionDialog;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.PageFilterPresenter;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.Section;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.ProductLaunchPresenter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IMemento;

public class ScoutProjectPropertyPart
extends AbstractSinglePageSectionBasedViewPart {
    private static final String SECTION_ID_FILTER = "section.filter";
    private static final String SECTION_ID_PRODUCT_LAUNCHER = "section.productLauncher";
    private ArrayList<ProductLaunchPresenter> m_launchPresenters = new ArrayList();

    @Override
    protected void createSections() {
        ISection filterSection = this.createSection(SECTION_ID_FILTER, "Filter");
        PageFilterPresenter filterPresenter = new PageFilterPresenter(this.getFormToolkit(), filterSection.getSectionClient(), this.getPage());
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        filterPresenter.getContainer().setLayoutData((Object)layoutData);
        this.getSection(SECTION_ID_FILTER).setExpanded(false);
        Section linkSection = (Section)this.createSection(SECTION_ID_PRODUCT_LAUNCHER, "Product launcher");
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)linkSection.getUiSection());
        Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        Action action = new Action(){

            public void run() {
                ArrayList<IFile> productFiles = new ArrayList<IFile>();
                for (ProductLaunchPresenter p : ScoutProjectPropertyPart.this.m_launchPresenters) {
                    productFiles.add(p.getProductFile());
                }
                ProductSelectionDialog dialog = new ProductSelectionDialog(ScoutProjectPropertyPart.this.getForm().getShell(), ScoutProjectPropertyPart.this.getScoutProject());
                dialog.setCheckedProductFiles(productFiles.toArray(new IFile[productFiles.size()]));
                if (dialog.open() == 0) {
                    ScoutProjectPropertyPart.this.updateProducts(dialog.getCheckedProductFiles());
                }
            }
        };
        action.setImageDescriptor(ScoutSdkUi.getImageDescriptor("usereditor.gif"));
        action.setToolTipText("edit content...");
        toolBarManager.add((IAction)action);
        toolBarManager.update(true);
        linkSection.getUiSection().setTextClient((Control)toolbar);
    }

    protected IScoutProject getScoutProject() {
        return (IScoutProject)this.getPage().getScoutResource();
    }

    private void updateProducts(IFile[] products) {
        ISection section = this.getSection(SECTION_ID_PRODUCT_LAUNCHER);
        for (ProductLaunchPresenter p : this.m_launchPresenters) {
            p.dispose();
        }
        this.m_launchPresenters.clear();
        Composite sectionClient = section.getSectionClient();
        TreeMap<CompositeObject, P_ProductFile> orderedProducts = new TreeMap<CompositeObject, P_ProductFile>();
        IFile[] iFileArray = products;
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            IFile productFile = iFileArray[n2];
            if (productFile != null && productFile.exists()) {
                IScoutBundle scoutBundle = ScoutSdk.getScoutWorkspace().getScoutBundle(productFile.getProject());
                int productType = -1;
                if (scoutBundle != null) {
                    productType = scoutBundle.getType();
                }
                orderedProducts.put(new CompositeObject(new Object[]{-productType, productFile.getName(), productFile}), new P_ProductFile(productFile, scoutBundle));
            }
            ++n2;
        }
        for (Map.Entry entry : orderedProducts.entrySet()) {
            P_ProductFile productFile = (P_ProductFile)entry.getValue();
            ProductLaunchPresenter presenter = new ProductLaunchPresenter(this.getFormToolkit(), sectionClient, productFile.getFile(), productFile.getBundle());
            GridData layoutData = new GridData(768);
            layoutData.widthHint = 200;
            presenter.getContainer().setLayoutData((Object)layoutData);
            this.m_launchPresenters.add(presenter);
        }
        this.getForm().layout(true, true);
        this.getForm().reflow(true);
    }

    @Override
    public void init(IMemento memento) {
        String[] productLocations;
        ArrayList<IFile> products = new ArrayList<IFile>();
        IEclipsePreferences node = new InstanceScope().getNode(ScoutSdkUi.getDefault().getBundle().getSymbolicName());
        String mementoProducts = node.get("section.productLauncher_" + this.getScoutProject().getProjectName(), "");
        if (!StringUtility.isNullOrEmpty((String)mementoProducts) && (productLocations = mementoProducts.split(",\\s*")) != null) {
            String[] stringArray = productLocations;
            int n = productLocations.length;
            int n2 = 0;
            while (n2 < n) {
                IFile productFile;
                String productPath = stringArray[n2];
                if (!StringUtility.isNullOrEmpty((String)productPath) && (productFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(productPath))) != null && productFile.exists()) {
                    products.add(productFile);
                }
                ++n2;
            }
        }
        this.updateProducts(products.toArray(new IFile[products.size()]));
    }

    @Override
    public void save(IMemento memento) {
        IFile[] files = new IFile[this.m_launchPresenters.size()];
        int i = 0;
        while (i < files.length) {
            files[i] = this.m_launchPresenters.get(i).getProductFile();
            ++i;
        }
        ScoutProjectPropertyPart.saveProductLaunchers(this.getScoutProject(), files);
    }

    public static void saveProductLaunchers(IScoutProject scoutProject, IFile[] files) {
        StringBuilder mementoString = new StringBuilder();
        int i = 0;
        while (i < files.length) {
            mementoString.append(files[i].getFullPath());
            if (i < files.length - 1) {
                mementoString.append(",");
            }
            ++i;
        }
        IEclipsePreferences node = new InstanceScope().getNode(ScoutSdkUi.getDefault().getBundle().getSymbolicName());
        node.put("section.productLauncher_" + scoutProject.getProjectName(), mementoString.toString());
    }

    private class P_ProductFile {
        private final IScoutBundle m_bundle;
        private final IFile m_file;

        public P_ProductFile(IFile file, IScoutBundle bundle) {
            this.m_file = file;
            this.m_bundle = bundle;
        }

        public IScoutBundle getBundle() {
            return this.m_bundle;
        }

        public IFile getFile() {
            return this.m_file;
        }
    }
}

