/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinkGroup;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.TypeOpenLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.LinksPresenter;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service.AbstractServiceNodePage;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.JdtTypePropertyPart;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ServicePropertyPart
extends JdtTypePropertyPart {
    private static final String SECTION_ID_LINKS = "section.links";
    final IType basicPermission = ScoutSdk.getType((String)"java.security.BasicPermission");
    final IType iForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");

    @Override
    protected void createSections() {
        ISection linkSection = this.createSection(SECTION_ID_LINKS, "Links");
        this.fillLinkSection(linkSection.getSectionClient());
        super.createSections();
    }

    @Override
    public AbstractServiceNodePage getPage() {
        return (AbstractServiceNodePage)super.getPage();
    }

    protected void fillLinkSection(Composite parent) {
        String entityName = null;
        LinksPresenterModel model = new LinksPresenterModel();
        if (this.getPage().getInterfaceType() != null) {
            model.addGlobalLink(new TypeOpenLink(this.getPage().getInterfaceType()));
        }
        if (this.getPage().getType() != null) {
            model.addGlobalLink(new TypeOpenLink(this.getPage().getType()));
            entityName = this.findEntityName(this.getPage().getType().getElementName());
        }
        if (!StringUtility.isNullOrEmpty(entityName)) {
            IType candidate;
            int n;
            int n2;
            IType[] iTypeArray;
            if (this.iForm != null) {
                String formRegex = String.valueOf(entityName) + "Form";
                ITypeFilter formFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getRegexSimpleNameFilter((String)formRegex), TypeFilters.getClassFilter(), TypeFilters.getInScoutProject((IScoutProject)this.getPage().getScoutResource().getScoutProject())});
                LinkGroup formGroup = model.getOrCreateGroup("Form", 10);
                iTypeArray = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iForm).getAllSubtypes(this.iForm, formFilter, TypeComparators.getTypeNameComparator());
                n2 = iTypeArray.length;
                n = 0;
                while (n < n2) {
                    candidate = iTypeArray[n];
                    formGroup.addLink(new TypeOpenLink(candidate));
                    ++n;
                }
            }
            String permissionRegex = "(Create|Read|Update)" + entityName + "Permission";
            ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getRegexSimpleNameFilter((String)permissionRegex), TypeFilters.getClassFilter(), TypeFilters.getInScoutProject((IScoutProject)this.getPage().getScoutResource().getScoutProject())});
            LinkGroup permissionGroup = model.getOrCreateGroup("Permissions", 20);
            iTypeArray = ScoutSdk.getPrimaryTypeHierarchy((IType)this.basicPermission).getAllSubtypes(this.basicPermission, filter, TypeComparators.getTypeNameComparator());
            n2 = iTypeArray.length;
            n = 0;
            while (n < n2) {
                candidate = iTypeArray[n];
                permissionGroup.addLink(new TypeOpenLink(candidate));
                ++n;
            }
        }
        LinksPresenter presenter = new LinksPresenter(this.getFormToolkit(), parent, model);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
    }

    private String findEntityName(String serviceName) {
        if (StringUtility.isNullOrEmpty((String)serviceName)) {
            return serviceName;
        }
        if (serviceName.endsWith("ProcessService")) {
            return serviceName.replaceAll("^(.*)ProcessService$", "$1");
        }
        if (serviceName.endsWith("OutlineService")) {
            return serviceName.replaceAll("^(.*)OutlineService$", "$1");
        }
        if (serviceName.endsWith("CustomService")) {
            return serviceName.replaceAll("^(.*)CustomService$", "$1");
        }
        if (serviceName.endsWith("CalendarService")) {
            return serviceName.replaceAll("^(.*)CalendarService$", "$1");
        }
        if (serviceName.endsWith("SmtpService")) {
            return serviceName.replaceAll("^(.*)SmtpService$", "$1");
        }
        if (serviceName.endsWith("SqlService")) {
            return serviceName.replaceAll("^(.*)SqlService$", "$1");
        }
        if (serviceName.endsWith("Service")) {
            return serviceName.replaceAll("^(.*)Service$", "$1");
        }
        return serviceName;
    }
}

