/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractPresenter {
    private Composite m_container;
    private final FormToolkit m_toolkit;

    public AbstractPresenter(FormToolkit toolkit, Composite parent) {
        this.m_toolkit = toolkit;
        this.m_container = this.getToolkit().createComposite(parent);
    }

    public boolean isMultiLine() {
        return false;
    }

    protected Font getFont(String symbolicName, boolean bold) {
        if (bold) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold(symbolicName);
        }
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(symbolicName);
    }

    public Composite getContainer() {
        return this.m_container;
    }

    public void dispose() {
        if (this.getContainer() != null && !this.getContainer().isDisposed()) {
            this.getContainer().dispose();
        }
    }

    public boolean isDisposed() {
        boolean disposed = true;
        if (this.getContainer() != null) {
            disposed = this.getContainer().isDisposed();
        }
        return disposed;
    }

    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.getContainer().setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        boolean enabled = false;
        if (this.getContainer() != null && !this.getContainer().isDisposed()) {
            enabled = this.getContainer().isEnabled();
        }
        return enabled;
    }

    public FormToolkit getToolkit() {
        return this.m_toolkit;
    }

    protected void toolkitAdapt(Control control) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.toolkitAdapt(c);
                ++n2;
            }
        }
        this.getToolkit().adapt(control, false, false);
    }
}

