/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.multi;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.ScoutIdeProperties;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.tooltip.CustomTooltip;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodBean;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodErrorPresenterContent;
import org.eclipse.scout.sdk.util.ScoutSignature;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethodSet;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class AbstractMultiMethodPresenter<T>
extends AbstractPresenter {
    private Hyperlink m_labelLink;
    private Composite m_body;
    private MethodErrorPresenterContent m_errorContent;
    private CustomTooltip m_tooltip;
    private HashMap<String, MethodBean<T>> m_methodSources = new HashMap();

    public AbstractMultiMethodPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
        this.create(this.getContainer());
    }

    public final void setMethodSet(ConfigurationMethodSet methodSet) {
        try {
            ConfigurationMethod[] configurationMethodArray = methodSet.getMethods();
            int n = configurationMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurationMethod method = configurationMethodArray[n2];
                String key = String.valueOf(method.getType().getFullyQualifiedName()) + ScoutSignature.getMethodIdentifier((IMethod)method.peekMethod());
                MethodBean<T> methodBean = this.m_methodSources.get(key);
                if (methodBean == null) {
                    methodBean = new MethodBean(method, key);
                    this.m_methodSources.put(key, methodBean);
                } else {
                    methodBean.setMethod(method);
                }
                ++n2;
            }
            try {
                this.init(methodSet);
            }
            catch (CoreException e) {
                ScoutSdkUi.logWarning("parse error in multi presenter. ", e);
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logWarning("could not compare method body with cached body of presenter '" + methodSet.getMethodName() + "'", e);
        }
        this.getContainer().layout(true);
    }

    protected void init(ConfigurationMethodSet methodSet) throws CoreException {
        this.m_labelLink.setText(ScoutIdeProperties.getMethodPresenterName((IMethod)this.getFirstMethod()));
        for (MethodBean<T> bean : this.m_methodSources.values()) {
            T sourceValue = this.parseSourceInput(PropertyMethodSourceUtilities.getMethodReturnValue((IMethod)bean.getMethod().peekMethod()), bean.getMethod());
            bean.setCurrentSourceValue(sourceValue);
            T defaultValue = this.parseSourceInput(bean.getMethod().computeDefaultValue(), bean.getMethod());
            bean.setDefaultValue(defaultValue);
        }
    }

    protected abstract String formatSourceValue(T var1) throws CoreException;

    protected abstract String formatDisplayValue(T var1) throws CoreException;

    protected abstract T parseSourceInput(String var1, ConfigurationMethod var2) throws CoreException;

    protected abstract T parseDisplayInput(String var1) throws CoreException;

    protected void create(Composite parent) {
        this.m_errorContent = new MethodErrorPresenterContent(parent, this.getToolkit());
        this.m_body = this.getToolkit().createComposite(parent);
        this.m_labelLink = this.getToolkit().createHyperlink(this.m_body, "", 0);
        this.m_tooltip = new CustomTooltip((Control)this.m_labelLink, false);
        Control content = this.createContent(this.m_body);
        GridLayout glayout = new GridLayout(1, true);
        glayout.horizontalSpacing = 0;
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        parent.setLayout((Layout)glayout);
        this.m_body.setLayoutData((Object)new GridData(1808));
        this.m_errorContent.setLayoutData(new GridData(1808));
        ((GridData)this.m_errorContent.getLayoutData()).exclude = true;
        this.m_body.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(0, 150);
        this.m_labelLink.setLayoutData((Object)data);
        if (content != null) {
            data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment((Control)this.m_labelLink, 5);
            data.right = new FormAttachment(100, 0);
            data.bottom = new FormAttachment(100, 0);
            content.setLayoutData((Object)data);
        }
    }

    protected abstract Control createContent(Composite var1);

    protected IMethod getFirstMethod() {
        if (this.m_methodSources == null || this.m_methodSources.size() < 1) {
            return null;
        }
        return new ArrayList<MethodBean<T>>(this.m_methodSources.values()).get(0).getMethod().peekMethod();
    }

    protected MethodBean<T>[] getMethodBeans() {
        return this.m_methodSources.values().toArray(new MethodBean[this.m_methodSources.size()]);
    }
}

