/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.single;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.table.AutoResizeColumnTable;
import org.eclipse.scout.sdk.ui.fields.table.JavaElementTableContentProvider;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractJavaElementListPresenter
extends AbstractMethodPresenter {
    private TableViewer m_viewer;
    private Table m_table;
    private TableColumn m_textColumn;
    private IJavaElement[] m_sourceElements;
    private JavaElementTableContentProvider m_tableModel;
    private Button m_removeButton;
    private Button m_addButton;

    public AbstractJavaElementListPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootArea = this.getToolkit().createComposite(container);
        Control table = this.createTable(rootArea);
        Control controlArea = this.createControlArea(rootArea);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        rootArea.setLayout((Layout)layout);
        GridData gdata = new GridData(1808);
        gdata.heightHint = this.m_table.getItemHeight() * 3 + 5;
        gdata.minimumWidth = 100;
        gdata.widthHint = 150;
        table.setLayoutData((Object)gdata);
        controlArea.setLayoutData((Object)new GridData());
        return rootArea;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            if (enabled) {
                this.m_removeButton.setEnabled(!this.m_viewer.getSelection().isEmpty());
            } else {
                this.m_removeButton.setEnabled(false);
            }
            this.m_addButton.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    private Control createTable(Composite container) {
        this.m_tableModel = new JavaElementTableContentProvider();
        this.m_table = new AutoResizeColumnTable(container, 67584);
        TableColumn simpleNameCol = new TableColumn(this.m_table, 16384);
        simpleNameCol.setData("columnWeight", (Object)new Integer(3));
        simpleNameCol.setWidth(170);
        simpleNameCol.setText("Member");
        this.m_table.setHeaderVisible(false);
        this.m_viewer = new TableViewer(this.m_table);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractJavaElementListPresenter.this.m_removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.m_viewer.setContentProvider((IContentProvider)this.m_tableModel);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)this.m_tableModel);
        this.m_viewer.setInput((Object)this);
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        return this.m_viewer.getControl();
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        super.init(method);
        this.m_sourceElements = this.readSource();
        this.m_tableModel.setElements(this.m_sourceElements);
        this.m_viewer.refresh();
        this.m_removeButton.setEnabled(!this.m_viewer.getSelection().isEmpty());
        this.m_addButton.setEnabled(true);
    }

    private Control createControlArea(Composite parent) {
        Composite pane = this.getToolkit().createComposite(parent);
        this.m_addButton = this.getToolkit().createButton(pane, "", 8);
        this.m_addButton.setImage(ScoutSdkUi.getImage("add.png"));
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractJavaElementListPresenter.this.handleAddComponent();
            }
        });
        this.m_addButton.setEnabled(false);
        this.m_removeButton = this.getToolkit().createButton(pane, "", 8);
        this.m_removeButton.setImage(ScoutSdkUi.getImage("remove.png"));
        this.m_removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractJavaElementListPresenter.this.handleRemoveComponent();
            }
        });
        this.m_removeButton.setEnabled(false);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        pane.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.heightHint = 22;
        gridData.widthHint = 22;
        this.m_addButton.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.heightHint = 22;
        gridData.widthHint = 22;
        this.m_removeButton.setLayoutData((Object)gridData);
        return pane;
    }

    private void handleRemoveComponent() {
        IJavaElement toRemove = (IJavaElement)((StructuredSelection)this.m_viewer.getSelection()).getFirstElement();
        ArrayList<IJavaElement> props = new ArrayList<IJavaElement>();
        IJavaElement[] iJavaElementArray = this.getSourceProps();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement prop = iJavaElementArray[n2];
            if (!prop.equals(toRemove)) {
                props.add(prop);
            }
            ++n2;
        }
        this.store(props.toArray(new IJavaElement[props.size()]));
    }

    protected abstract void handleAddComponent();

    public abstract IJavaElement[] readSource() throws CoreException;

    public abstract void store(IJavaElement[] var1);

    public IJavaElement[] getSourceProps() {
        return this.m_sourceElements;
    }
}

