/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.single;

import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.sdk.ScoutIdeProperties;
import org.eclipse.scout.sdk.ScoutStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.tooltip.JavadocTooltip;
import org.eclipse.scout.sdk.ui.jdt.JdtUiUtility;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodErrorPresenterContent;
import org.eclipse.scout.sdk.util.ScoutSourceUtilities;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractMethodPresenter
extends AbstractPresenter {
    private ConfigurationMethod m_configurationMethod;
    private Hyperlink m_labelLink;
    private Composite m_body;
    private MethodErrorPresenterContent m_errorContent;
    private JavadocTooltip m_tooltip;
    private ImageHyperlink m_deleteButton;

    public AbstractMethodPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
        this.create(this.getContainer());
    }

    protected void init(ConfigurationMethod method) throws CoreException {
        this.m_labelLink.setText(ScoutIdeProperties.getMethodPresenterName((IMethod)method.peekMethod()));
        this.m_labelLink.setEnabled(true);
        this.m_labelLink.setFont(this.getFont("org.eclipse.jface.dialogfont", method.isImplemented()));
        this.m_labelLink.getParent().layout();
        this.m_tooltip.setMember((IMember)method.peekMethod());
    }

    protected void create(Composite parent) {
        this.m_errorContent = new MethodErrorPresenterContent(parent, this.getToolkit());
        Control body = this.createBody(parent);
        GridLayout glayout = new GridLayout(1, true);
        glayout.horizontalSpacing = 0;
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        parent.setLayout((Layout)glayout);
        body.setLayoutData((Object)new GridData(1808));
        this.m_errorContent.setLayoutData(new GridData(1808));
        ((GridData)this.m_errorContent.getLayoutData()).exclude = true;
    }

    private Control createBody(Composite parent) {
        this.m_body = this.getToolkit().createComposite(parent);
        Composite linkComposite = this.getToolkit().createComposite(this.m_body);
        this.m_labelLink = this.getToolkit().createHyperlink(linkComposite, "", 0);
        HyperlinkAdapter actionListener = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractMethodPresenter.this.handleLabelLinkSelected();
            }
        };
        this.m_labelLink.addHyperlinkListener((IHyperlinkListener)actionListener);
        this.m_tooltip = new JavadocTooltip((Control)this.m_labelLink);
        Control content = this.createContent(this.m_body);
        Composite buttonArea = this.getToolkit().createComposite(this.m_body);
        Canvas placeHolderControl = new Canvas(buttonArea, 0);
        this.fillButtonArea(buttonArea);
        GridLayout bodyLayout = new GridLayout(3, false);
        bodyLayout.horizontalSpacing = 0;
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        bodyLayout.verticalSpacing = 0;
        this.m_body.setLayout((Layout)bodyLayout);
        GridData linkCompData = new GridData();
        linkCompData.widthHint = 130;
        linkComposite.setLayoutData((Object)linkCompData);
        GridData contentData = new GridData(768);
        content.setLayoutData((Object)contentData);
        GridData buttonAreaData = new GridData(1040);
        buttonArea.setLayoutData((Object)buttonAreaData);
        RowLayout linkCompLayout = new RowLayout(256);
        linkCompLayout.marginBottom = 0;
        linkCompLayout.marginLeft = 0;
        linkCompLayout.marginRight = 0;
        linkCompLayout.marginTop = 0;
        linkCompLayout.spacing = 0;
        linkComposite.setLayout((Layout)linkCompLayout);
        GridLayout buttonBarLayout = new GridLayout(100, false);
        buttonBarLayout.horizontalSpacing = 0;
        buttonBarLayout.marginHeight = 0;
        buttonBarLayout.marginWidth = 0;
        buttonBarLayout.verticalSpacing = 0;
        buttonArea.setLayout((Layout)buttonBarLayout);
        placeHolderControl.setLayoutData((Object)new GridData(1, 1));
        return this.m_body;
    }

    protected void fillButtonArea(Composite buttonArea) {
        this.m_deleteButton = this.getToolkit().createImageHyperlink(buttonArea, 8);
        this.m_deleteButton.setImage(ScoutSdkUi.getImage("remove.png"));
        this.m_deleteButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (AbstractMethodPresenter.this.getMethod().isImplemented()) {
                    ScoutMethodDeleteOperation op = new ScoutMethodDeleteOperation(AbstractMethodPresenter.this.getMethod().peekMethod());
                    OperationJob job = new OperationJob((IOperation)op);
                    job.schedule();
                }
            }
        });
        GridData deleteButtonData = new GridData(1028);
        this.m_deleteButton.setLayoutData((Object)deleteButtonData);
    }

    protected abstract Control createContent(Composite var1);

    public final void setMethod(ConfigurationMethod configurationMethod) {
        try {
            this.getContainer().setRedraw(false);
            this.m_configurationMethod = configurationMethod;
            try {
                this.init(configurationMethod);
                this.m_body.setVisible(true);
                this.m_errorContent.setVisible(false);
                ((GridData)this.m_errorContent.getLayoutData()).exclude = true;
                ((GridData)this.m_body.getLayoutData()).exclude = false;
            }
            catch (CoreException coreException) {
                this.m_errorContent.setMethod(configurationMethod);
                this.m_body.setVisible(false);
                this.m_errorContent.setVisible(true);
                ((GridData)this.m_errorContent.getLayoutData()).exclude = false;
                ((GridData)this.m_body.getLayoutData()).exclude = true;
            }
            ((GridData)this.m_deleteButton.getLayoutData()).exclude = !configurationMethod.isImplemented();
            this.m_deleteButton.setVisible(configurationMethod.isImplemented());
            this.m_deleteButton.setToolTipText("Remove '" + this.getMethod().getMethodName() + "' in '" + this.getMethod().getType().getElementName() + "'...");
        }
        finally {
            this.getContainer().setRedraw(true);
            this.getContainer().layout(true, true);
        }
    }

    public ConfigurationMethod getMethod() {
        return this.m_configurationMethod;
    }

    public void setLabelText(String text) {
        if (!this.isDisposed()) {
            this.m_labelLink.setText(text);
        }
    }

    public String getLabelText() {
        String labelText = null;
        if (!this.isDisposed()) {
            labelText = this.m_labelLink.getText();
        }
        return labelText;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_errorContent.setEnabled(enabled);
            this.m_deleteButton.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_errorContent.isEnabled();
        }
        return false;
    }

    protected void handleLabelLinkSelected() {
        this.showJavaElementInEditor((IJavaElement)this.getMethod().peekMethod());
    }

    protected void showJavaElementInEditor(IJavaElement e) {
        this.showJavaElementInEditor(e, true);
    }

    protected void showJavaElementInEditor(IJavaElement e, boolean createNew) {
        JdtUiUtility.showJavaElementInEditor(e, createNew);
    }

    protected final String readInitalValue() throws CoreException {
        try {
            Matcher m = Pattern.compile("\\{\\s*return\\s*([^\\;]*)\\s*\\;.*\\}", 32).matcher(this.getMethod().peekMethod().getSource());
            if (m.find()) {
                return m.group(1);
            }
            throw new CoreException((IStatus)new ScoutStatus(this.getMethod().peekMethod().getSource()));
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError(e);
            return null;
        }
    }

    private String wellFormMethod() throws JavaModelException, MalformedTreeException, BadLocationException {
        String methodBody = this.getMethod().peekMethod().getSource();
        if (methodBody == null) {
            ScoutSdkUi.logWarning("methodBody of " + this.getMethod().getMethodName() + " in " + this.getMethod().getType().getFullyQualifiedName() + " is null");
        }
        String newBody = methodBody;
        newBody = ScoutSourceUtilities.removeLineLeadingTab((int)(ScoutUtility.getIndent((IType)this.getMethod().peekMethod().getDeclaringType()).length() + 1), (String)newBody);
        newBody = newBody.replaceAll("\t", "  ");
        return newBody;
    }

    protected String getJavaDoc() {
        try {
            Reader contentReader = JavadocContentAccess.getContentReader((IMember)this.getMethod().peekMethod(), (boolean)true);
            if (contentReader != null) {
                return IOUtility.getContent((Reader)contentReader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

