/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.single;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jdt.signature.IImportValidator;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.JavaClassProposal;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractTypeProposalPresenter
extends AbstractProposalPresenter<JavaClassProposal> {
    private String m_labelMethodName;
    private boolean m_includeNullProposal;
    private static final JavaClassProposal NULL_PROPOSAL = new JavaClassProposal("None", ScoutSdkUi.getImage("default.gif"), null);

    public AbstractTypeProposalPresenter(FormToolkit toolkit, Composite parent, String labelMethodName, boolean includeNullProposal) {
        super(toolkit, parent);
        this.m_labelMethodName = labelMethodName;
        this.m_includeNullProposal = includeNullProposal;
    }

    protected abstract IType[] provideScoutTypes(IJavaProject var1, IType var2) throws CoreException;

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        ArrayList<JavaClassProposal> proposals = new ArrayList<JavaClassProposal>();
        IType[] iTypeArray = this.provideScoutTypes(method.getType().getJavaProject(), method.getType());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            proposals.add(new JavaClassProposal(ScoutProposalUtility.getFieldName(t, this.m_labelMethodName), ScoutSdkUi.getImage("default.gif"), t));
            ++n2;
        }
        if (this.m_includeNullProposal) {
            proposals.add(NULL_PROPOSAL);
        }
        this.setProposals(proposals.toArray(new JavaClassProposal[proposals.size()]));
        super.init(method);
    }

    @Override
    protected JavaClassProposal parseInput(String input) throws CoreException {
        IType referedType = PropertyMethodSourceUtilities.parseReturnParameterClass((String)input, (IMethod)this.getMethod().peekMethod());
        return this.findProposal(referedType);
    }

    @Override
    protected synchronized void storeValue(final JavaClassProposal value) {
        Object op = null;
        if (ScoutSdkUtility.equals((Object)((JavaClassProposal)this.getDefaultValue()), (Object)value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName()){

                protected String createMethodBody(IMethod methodToOverride, IImportValidator validator) throws JavaModelException {
                    StringBuilder source = new StringBuilder();
                    source.append("  return ");
                    if (value != null && value.getJavaClass() != null) {
                        IType javaClass = value.getJavaClass();
                        source.append(String.valueOf(ScoutSdkUtility.getSimpleTypeRefName((String)Signature.createTypeSignature((String)javaClass.getFullyQualifiedName(), (boolean)true), (IImportValidator)validator)) + ".class;");
                    } else {
                        source.append("null;");
                    }
                    return source.toString();
                }
            };
            ((ConfigPropertyMethodUpdateOperation)op).setFormatSource(true);
        }
        new OperationJob(op).schedule();
    }

    private JavaClassProposal findProposal(IType type) {
        JavaClassProposal[] javaClassProposalArray = (JavaClassProposal[])this.getProposals();
        int n = javaClassProposalArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClassProposal prop = javaClassProposalArray[n2];
            if (CompareUtility.equals((Object)prop.getJavaClass(), (Object)type)) {
                return prop;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void createContextMenu(MenuManager manager) {
        IType t;
        super.createContextMenu(manager);
        if (this.getCurrentSourceValue() != null && (t = ((JavaClassProposal)this.getCurrentSourceValue()).getJavaClass()) != null) {
            manager.add((IAction)new Action("Go to " + t.getElementName(), ScoutSdkUi.getImageDescriptor("info.gif")){

                public void run() {
                    AbstractTypeProposalPresenter.this.showJavaElementInEditor((IJavaElement)t);
                }
            });
        }
    }
}

