/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.sdk.ScoutIdeProperties;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.tooltip.CustomTooltip;
import org.eclipse.scout.sdk.util.ScoutSourceUtilities;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class MethodErrorPresenterContent
extends Composite {
    private final FormToolkit m_toolkit;
    private Hyperlink m_labelLink;
    private Label m_statusLabel;
    private Label m_statusIcon;
    private Button m_deleteButton;
    private ConfigurationMethod m_configurationMethod;
    private CustomTooltip m_customTooltip;

    public MethodErrorPresenterContent(Composite parent, FormToolkit toolkit) {
        super(parent, 0);
        this.m_toolkit = toolkit;
        this.createContent(this);
    }

    private void createContent(Composite parent) {
        Control labelArea = this.createLabelArea(parent);
        Control bodyArea = this.createBodyArea(parent);
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(0, 150);
        labelArea.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(labelArea, 5);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        bodyArea.setLayoutData((Object)data);
    }

    private Control createBodyArea(Composite rootArea) {
        Composite area = this.getToolkit().createComposite(rootArea);
        this.m_statusIcon = this.getToolkit().createLabel(area, "");
        this.m_statusLabel = this.getToolkit().createLabel(area, "");
        this.m_deleteButton = this.getToolkit().createButton(area, Texts.get((String)"Delete"), 8);
        this.m_deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new OperationJob((IOperation)new ScoutMethodDeleteOperation(MethodErrorPresenterContent.this.getMethod().peekMethod())).schedule();
            }
        });
        GridLayout glayout = new GridLayout(3, false);
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        glayout.horizontalSpacing = 3;
        area.setLayout((Layout)glayout);
        this.m_statusIcon.setLayoutData((Object)new GridData(1));
        this.m_statusLabel.setLayoutData((Object)new GridData(768));
        GridData gData = new GridData(-1, 22);
        this.m_deleteButton.setLayoutData((Object)gData);
        this.m_deleteButton.setEnabled(false);
        return area;
    }

    private Control createLabelArea(Composite parent) {
        Composite area = this.getToolkit().createComposite(parent);
        this.m_labelLink = this.getToolkit().createHyperlink(area, "", 0);
        this.m_customTooltip = new CustomTooltip((Control)this.m_labelLink, true);
        this.m_labelLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MethodErrorPresenterContent.this.showMethodInEditor(MethodErrorPresenterContent.this.m_configurationMethod.peekMethod());
            }
        });
        this.m_labelLink.setEnabled(false);
        GridLayout glayout = new GridLayout(3, false);
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        glayout.horizontalSpacing = 3;
        area.setLayout((Layout)glayout);
        this.m_labelLink.setLayoutData((Object)new GridData());
        return area;
    }

    public ConfigurationMethod getMethod() {
        return this.m_configurationMethod;
    }

    public void setMethod(ConfigurationMethod method) {
        this.m_configurationMethod = method;
        this.m_labelLink.setText(ScoutIdeProperties.getMethodPresenterName((IMethod)method.peekMethod()));
        this.m_labelLink.setEnabled(true);
        this.m_labelLink.setFont(this.getFont("org.eclipse.jface.dialogfont", this.getMethod().isImplemented()));
        try {
            this.m_customTooltip.setText(this.wellFormMethod());
        }
        catch (JavaModelException e1) {
            ScoutSdkUi.logWarning("could not create tooltip for '" + method.getMethodName() + "'", e1);
        }
        this.m_deleteButton.setEnabled(method.isImplemented());
        this.setStatus((IStatus)new Status(4, "org.eclipse.scout.sdk", "Unaccepted value!"));
    }

    public void setStatus(IStatus status) {
        Image image = null;
        String message = "";
        if (status != null) {
            switch (status.getSeverity()) {
                case 4: {
                    image = ScoutSdkUi.getImage("error.gif");
                    break;
                }
                case 2: {
                    image = ScoutSdkUi.getImage("warning.gif");
                    break;
                }
                case 1: {
                    image = ScoutSdkUi.getImage("info.gif");
                }
            }
            message = status.getMessage();
        }
        this.m_statusIcon.setImage(image);
        this.m_statusLabel.setText(message);
    }

    protected FormToolkit getToolkit() {
        return this.m_toolkit;
    }

    protected void showMethodInEditor(IMethod method) {
        try {
            ITextEditor textEditor;
            IRegion reg;
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)method);
            JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)method);
            if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning(e);
        }
    }

    private String wellFormMethod() throws JavaModelException {
        String methodBody = this.getMethod().peekMethod().getSource();
        String newBody = ScoutSourceUtilities.removeLeadingCommentAndAnnotationLines((String)methodBody);
        newBody = ScoutSourceUtilities.removeLineLeadingTab((int)(ScoutUtility.getIndent((IType)this.getMethod().getType()).length() + 1), (String)newBody);
        newBody = newBody.replaceAll("\t", "  ");
        return newBody;
    }

    protected Font getFont(String symbolicName, boolean bold) {
        if (bold) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold(symbolicName);
        }
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(symbolicName);
    }
}

