/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractScoutWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IWizardPageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ScoutWizardDialog
extends WizardDialog
implements IWizardPageContainer {
    public ScoutWizardDialog(IWizard newWizard) {
        this(ScoutSdkUi.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), newWizard);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    public ScoutWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        super.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() instanceof AbstractScoutWizardPage) {
                    AbstractScoutWizardPage selectedPage = (AbstractScoutWizardPage)((Object)event.getSelectedPage());
                    ScoutWizardDialog.this.setStatus(selectedPage.getStatus(), selectedPage.getDefaultOkStatus());
                    selectedPage.postActivate();
                }
            }
        });
    }

    public void showPage(IWizardPage page) {
        super.showPage(page);
        if (page instanceof AbstractScoutWizardPage) {
            ((AbstractScoutWizardPage)page).setFocus();
        } else {
            page.getControl().setFocus();
        }
    }

    @Override
    public void setStatus(IStatus status, IStatus defaultOkStatus) {
        int messagetype;
        IStatus highestSeverityStatus = this.getHighestSeverityStatus(status, defaultOkStatus);
        switch (highestSeverityStatus.getSeverity()) {
            case 1: {
                messagetype = 1;
                break;
            }
            case 2: {
                messagetype = 2;
                break;
            }
            case 4: {
                messagetype = 3;
                break;
            }
            default: {
                messagetype = 0;
            }
        }
        String message = highestSeverityStatus.getMessage();
        this.setMessage(message, messagetype);
    }

    private IStatus getHighestSeverityStatus(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                highestSeverity = this.getHighestSeverityStatus(child, highestSeverity);
                ++n2;
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }
}

