/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.beanproperty;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IBeanPropertyNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SignatureProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BeanPropertyNewWizardPage
extends AbstractWorkspaceWizardPage {
    private String m_beanName;
    private SignatureProposal m_beanSignature;
    private StyledTextField m_beanNameField;
    private ProposalTextField m_beanTypeField;
    private IBeanPropertyNewOperation m_operation;
    private Set<String> m_notAllowedNames;
    private final IJavaSearchScope m_searchScope;

    public BeanPropertyNewWizardPage(IJavaSearchScope searchScope) {
        super("New Property Bean");
        this.m_searchScope = searchScope;
        this.setTitle("New Property Bean");
        this.setDefaultMessage("create a new property bean.");
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_beanNameField = new StyledTextField(parent, Texts.get((String)"Dialog_rename_oldNameLabel"));
        this.m_beanNameField.setText(this.getBeanName());
        this.m_beanNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanPropertyNewWizardPage.this.m_beanName = BeanPropertyNewWizardPage.this.m_beanNameField.getText();
                BeanPropertyNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_beanTypeField = new ProposalTextField(parent, new SignatureProposalProvider(this.m_searchScope, true, true));
        this.m_beanTypeField.setLabelText(Texts.get((String)"Dialog_propertyBean_typeLabel"));
        this.m_beanTypeField.acceptProposal(this.getBeanSignature());
        this.m_beanTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    BeanPropertyNewWizardPage.this.setStateChanging(true);
                    BeanPropertyNewWizardPage.this.m_beanSignature = (SignatureProposal)event.proposal;
                }
                finally {
                    BeanPropertyNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_beanNameField.setLayoutData(new GridData(768));
        this.m_beanTypeField.setLayoutData(new GridData(768));
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        IStatus status = this.getPropertyNameStatus();
        multiStatus.add(status);
        multiStatus.add(this.getPropertyTypeStatus());
    }

    private IStatus getPropertyNameStatus() {
        String propertyName = this.getBeanName();
        if (propertyName == null || propertyName.length() == 0) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (this.m_notAllowedNames != null && (this.m_notAllowedNames.contains("get" + this.getBeanName(true)) || this.m_notAllowedNames.contains("set" + this.getBeanName(true)) || this.m_notAllowedNames.contains("is" + this.getBeanName(true)))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (propertyName.matches("\\b[a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (propertyName.matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{propertyName}));
    }

    private IStatus getPropertyTypeStatus() {
        SignatureProposal signature = this.getBeanSignature();
        if (signature == null) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_beanTypeNull"));
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager manager) throws CoreException {
        this.m_operation.setBeanName(this.getBeanName());
        if (this.getBeanSignature() != null) {
            this.m_operation.setBeanTypeSignature(this.getBeanSignature().getSignature());
        }
        this.m_operation.setMethodFlags(1);
        this.m_operation.run(monitor, manager);
        return true;
    }

    public Set<String> getNotAllowedNames() {
        return this.m_notAllowedNames;
    }

    public void setNotAllowedNames(Set<String> notAllowedNames) {
        this.m_notAllowedNames = notAllowedNames;
    }

    public IBeanPropertyNewOperation getOperation() {
        return this.m_operation;
    }

    public void setOperation(IBeanPropertyNewOperation operation) {
        this.m_operation = operation;
    }

    public String getBeanName() {
        return this.m_beanName;
    }

    public String getBeanName(boolean startWithUpperCase) {
        if (StringUtility.isNullOrEmpty((String)this.getBeanName())) {
            return null;
        }
        if (startWithUpperCase) {
            return String.valueOf(Character.toUpperCase(this.getBeanName().charAt(0))) + this.getBeanName().substring(1);
        }
        return String.valueOf(Character.toLowerCase(this.getBeanName().charAt(0))) + this.getBeanName().substring(1);
    }

    public void setBeanName(String beanName) {
        try {
            this.setStateChanging(true);
            this.m_beanName = beanName;
            if (this.isControlCreated()) {
                this.m_beanNameField.setText(beanName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SignatureProposal getBeanSignature() {
        return this.m_beanSignature;
    }

    public void setBeanSignature(SignatureProposal beanSignature) {
        try {
            this.setStateChanging(true);
            this.m_beanSignature = beanSignature;
            if (this.isControlCreated()) {
                this.m_beanTypeField.acceptProposal(beanSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

