/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.bundle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.project.BundleImportOperation;
import org.eclipse.scout.sdk.pde.Manifest;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.PluginDescriptorProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.BundleTypeProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BundleImportWizardPage
extends AbstractWorkspaceWizardPage {
    private StyledTextField m_projectIdField;
    private ProposalTextField m_pluginModelField;
    private ProposalTextField m_bundleTypeField;
    private String m_projectId;
    private PluginDescriptorProposal m_pluginModel;
    private BundleTypeProposal m_bundleType;
    private HashMap<Integer, BundleTypeProposal> m_bundleProposals = new HashMap();
    private boolean m_projectIdFieldEnabled = true;
    private boolean m_projectAliasFieldEnabled = true;
    private boolean m_autoGeneratedProjectId = true;
    private boolean m_autoGeneratedAlias = true;
    private int LEGACY_PROJECT_ID = 2;
    private int LEGACY_BUNDLE_TYPE = 8;

    public BundleImportWizardPage() {
        super(BundleImportWizardPage.class.getName());
        this.setTitle("Import Scout Bundle");
        this.setDefaultMessage("Import an existing workspace bundle to a Scout Project.");
    }

    @Override
    protected void createContent(Composite parent) {
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        ArrayList<PluginDescriptorProposal> proposals = new ArrayList<PluginDescriptorProposal>();
        Object[] objectArray = workspaceModels;
        int n = workspaceModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel = objectArray[n2];
            IProject p = pluginModel.getUnderlyingResource().getProject();
            if (ScoutSdk.getScoutWorkspace().getScoutBundle(p) == null) {
                proposals.add(new PluginDescriptorProposal(pluginModel));
            }
            ++n2;
        }
        this.m_pluginModelField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(proposals.toArray(new IContentProposalEx[proposals.size()])), "Plugin to import");
        this.m_pluginModelField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    BundleImportWizardPage.this.setStateChanging(true);
                    BundleImportWizardPage.this.setPluginSelectionInternal((PluginDescriptorProposal)event.proposal);
                }
                finally {
                    BundleImportWizardPage.this.setStateChanging(false);
                }
            }
        });
        objectArray = ScoutProposalUtility.getAllBundleProposals();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            IPluginModelBase p = objectArray[n2];
            this.m_bundleProposals.put(p.getType(), (BundleTypeProposal)p);
            ++n2;
        }
        this.m_bundleTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(ScoutProposalUtility.getAllBundleProposals()), "Bundle type");
        this.m_bundleTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                BundleImportWizardPage.this.m_bundleType = (BundleTypeProposal)event.proposal;
                BundleImportWizardPage.this.pingStateChanging();
            }
        });
        this.m_projectIdField = this.getFieldToolkit().createStyledTextField(parent, "Scout Project ID");
        this.m_projectIdField.setText(this.getProjectId());
        this.m_projectIdField.setEnabled(this.isProjectIdFieldEnabled());
        this.m_projectIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BundleImportWizardPage.this.m_projectId = BundleImportWizardPage.this.m_projectIdField.getText();
                BundleImportWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_pluginModelField.setLayoutData(new GridData(768));
        this.m_bundleTypeField.setLayoutData(new GridData(768));
        this.m_projectIdField.setLayoutData(new GridData(768));
    }

    private void setPluginSelectionInternal(PluginDescriptorProposal proposal) {
        if (proposal == null) {
            this.m_bundleTypeField.acceptProposal(null);
        } else {
            Matcher m;
            int legacyCoding = 0;
            Manifest mf = new Manifest();
            String bundleName = proposal.getPluginBase().getBundleDescription().getName();
            try {
                String bundleType;
                mf.read((IFile)proposal.getPluginBase().getUnderlyingResource());
                String groupId = mf.getAttribute("BsiCase-ProjectGroupId");
                if (!StringUtility.isNullOrEmpty((String)groupId)) {
                    legacyCoding |= this.LEGACY_PROJECT_ID;
                    this.setProjectIdInternal(groupId);
                }
                if (!StringUtility.isNullOrEmpty((String)(bundleType = mf.getAttribute("BsiCase-BundleType")))) {
                    if (bundleType.equals("client")) {
                        legacyCoding |= this.LEGACY_BUNDLE_TYPE;
                        this.setBundleType(this.m_bundleProposals.get(2));
                    } else if (bundleType.equals("shared")) {
                        legacyCoding |= this.LEGACY_BUNDLE_TYPE;
                        this.setBundleType(this.m_bundleProposals.get(4));
                    } else if (bundleType.equals("server")) {
                        legacyCoding |= this.LEGACY_BUNDLE_TYPE;
                        this.setBundleType(this.m_bundleProposals.get(8));
                    }
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logWarning("could not parse manifest of '" + proposal.getPluginBase().getBundleDescription().getName() + "'.", e);
            }
            if ((legacyCoding & this.LEGACY_BUNDLE_TYPE) == 0) {
                if (bundleName.matches("^.*client\\.test.*$")) {
                    this.setBundleType(this.m_bundleProposals.get(256));
                } else if (bundleName.matches("^.*client.*$")) {
                    this.setBundleType(this.m_bundleProposals.get(2));
                } else if (bundleName.matches("^.*shared.*$")) {
                    this.setBundleType(this.m_bundleProposals.get(4));
                } else if (bundleName.matches("^.*server\\.app.*$")) {
                    this.setBundleType(this.m_bundleProposals.get(16));
                } else if (bundleName.matches("^.*server.*$")) {
                    this.setBundleType(this.m_bundleProposals.get(8));
                } else if (bundleName.matches("^.*ui\\.swt.*$")) {
                    this.setBundleType(this.m_bundleProposals.get(32));
                } else if (bundleName.matches("^.*ui\\.swing.*$")) {
                    this.setBundleType(this.m_bundleProposals.get(128));
                }
            }
            if ((m = Pattern.compile("^(([^.]*\\.)*)([^.]*)\\.(client|ui\\.swt\\.app|ui\\.swt|ui\\.swing|shared|server\\.app | server).*$").matcher(proposal.getPluginBase().getBundleDescription().getName())).find() && (legacyCoding & this.LEGACY_PROJECT_ID) == 0) {
                String id = m.group(1);
                if (id.length() > 0) {
                    id = id.substring(0, id.length() - 1);
                }
                this.setProjectId(id);
            }
        }
        this.m_pluginModel = proposal;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        BundleImportOperation operation = new BundleImportOperation();
        operation.setProjectId(this.getProjectId());
        operation.setBundleType(this.getBundleType().getType());
        operation.setPluginModel(this.getPluginModel().getPluginBase());
        operation.run(monitor, workingCopyManager);
        return true;
    }

    public void setProjectId(String projectId) {
        try {
            this.setStateChanging(true);
            this.setProjectIdInternal(projectId);
            this.m_autoGeneratedProjectId = false;
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setProjectIdInternal(String projectId) {
        this.m_projectId = projectId;
        if (this.isControlCreated()) {
            this.m_projectIdField.setText(projectId);
        }
    }

    public String getProjectId() {
        return this.m_projectId;
    }

    public void setPluginModel(PluginDescriptorProposal pluginModel) {
        this.m_pluginModel = pluginModel;
    }

    public PluginDescriptorProposal getPluginModel() {
        return this.m_pluginModel;
    }

    protected void setBundleType(BundleTypeProposal bundleType) {
        try {
            this.setStateChanging(true);
            this.m_bundleType = bundleType;
            if (this.isControlCreated()) {
                this.m_bundleTypeField.acceptProposal(bundleType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected BundleTypeProposal getBundleType() {
        return this.m_bundleType;
    }

    public void setProjectIdFieldEnabled(boolean projectIdFieldEnabled) {
        this.m_projectIdFieldEnabled = projectIdFieldEnabled;
        if (this.isControlCreated()) {
            this.m_projectIdField.setEnabled(projectIdFieldEnabled);
        }
    }

    public boolean isProjectIdFieldEnabled() {
        return this.m_projectIdFieldEnabled;
    }
}

