/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.bundle;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.KeyStrokeNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BundleNewWizardPage
extends AbstractWorkspaceWizardPage {
    private StyledTextField m_bundleNameField;
    private String m_bundleName;
    private KeyStrokeNewOperation m_operation;
    private IScoutBundle m_parentBundle;

    public BundleNewWizardPage(IScoutBundle bundle) {
        super(BundleNewWizardPage.class.getName());
        this.m_parentBundle = bundle;
        this.setTitle("New Scout Bundle");
        this.setDefaultMessage("Create a new Scout Bundle");
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_bundleNameField = this.getFieldToolkit().createStyledTextField(parent, "Bundle Name");
        this.m_bundleNameField.setReadOnlyPrefix(this.getParentBundle().getScoutProject().getProjectName());
        this.m_bundleNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BundleNewWizardPage.this.m_bundleName = BundleNewWizardPage.this.m_bundleNameField.getText();
                BundleNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_bundleNameField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        return true;
    }

    public KeyStrokeNewOperation getOperation() {
        return this.m_operation;
    }

    public void setOperation(KeyStrokeNewOperation operation) {
        this.m_operation = operation;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getBundleName()) || this.getBundleName().equals(this.getParentBundle().getScoutProject().getProjectName())) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ResourcesPlugin.getWorkspace().getRoot().getProject(this.getBundleName()) != null) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (!this.getBundleName().matches("[a-zA-Z0-9\\._-]*")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getBundleName()}));
        }
        return Status.OK_STATUS;
    }

    public void setParentBundle(IScoutBundle bundle) {
        if (this.isControlCreated()) {
            throw new IllegalStateException("wizard page already created.");
        }
        this.m_parentBundle = bundle;
    }

    public IScoutBundle getParentBundle() {
        return this.m_parentBundle;
    }

    public void setBundleName(String bundleName) {
        try {
            this.setStateChanging(true);
            this.m_bundleName = bundleName;
            if (this.isControlCreated()) {
                this.m_bundleNameField.setText(bundleName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getBundleName() {
        return this.m_bundleName;
    }
}

