/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.code.type;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.CodeTypeNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SignatureProposal;
import org.eclipse.scout.sdk.ui.internal.extensions.CodeIdExtensionPoint;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CodeTypeNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iCodeType = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType");
    final IType abstractCodeType = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.common.code.AbstractCodeType");
    private String m_nextCodeId;
    private NlsProposal m_nlsName;
    private String m_typeName;
    private ITypeProposal m_superType;
    private SignatureProposal m_genericSignature;
    private StyledTextField m_nextCodeIdField;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_genericTypeField;
    private final IScoutBundle m_sharedBundle;

    public CodeTypeNewWizardPage(IScoutBundle sharedBundle) {
        super(CodeTypeNewWizardPage.class.getName());
        this.m_sharedBundle = sharedBundle;
        this.setTitle("New Code Type");
        this.setDefaultMessage("Create a new code type.");
        this.m_superType = ScoutProposalUtility.getScoutTypeProposalsFor(this.abstractCodeType)[0];
        this.m_genericSignature = new SignatureProposal(Signature.createTypeSignature((String)Long.class.getName(), (boolean)true));
    }

    @Override
    public void postActivate() {
        this.m_nlsNameField.setFocus();
    }

    @Override
    protected void createContent(Composite parent) {
        if (this.getGenericSignature() != null) {
            this.setNextCodeId(CodeIdExtensionPoint.getNextCodeId(this.getSharedBundle().getScoutProject(), this.getGenericSignature().getSignature()));
        }
        this.m_nextCodeIdField = this.getFieldToolkit().createStyledTextField(parent, "Code ID");
        this.m_nextCodeIdField.setText(this.getNextCodeId());
        this.m_nextCodeIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeTypeNewWizardPage.this.m_nextCodeId = CodeTypeNewWizardPage.this.m_nextCodeIdField.getText();
                CodeTypeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, this.getSharedBundle().findBestMatchNlsProject(), "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (CodeTypeNewWizardPage.this.getNlsName() != null) {
                        oldEntry = CodeTypeNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    CodeTypeNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (CodeTypeNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(CodeTypeNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)CodeTypeNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        CodeTypeNewWizardPage.this.m_typeNameField.setText(CodeTypeNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("CodeType");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeTypeNewWizardPage.this.m_typeName = CodeTypeNewWizardPage.this.m_typeNameField.getText();
                CodeTypeNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.common.code.AbstractCodeType"));
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(SdkTypeUtility.getAbstractTypesOnClasspath((IType)this.iCodeType, (IJavaProject)this.getSharedBundle().getJavaProject()));
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(shotList, proposals), "Super Type");
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    CodeTypeNewWizardPage.this.m_superType = (ITypeProposal)event.proposal;
                    if (CodeTypeNewWizardPage.this.getSuperType() != null && TypeUtility.isGenericType((IType)CodeTypeNewWizardPage.this.getSuperType().getType())) {
                        CodeTypeNewWizardPage.this.m_genericTypeField.setEnabled(true);
                        if (CodeTypeNewWizardPage.this.getGenericSignature() == null) {
                            CodeTypeNewWizardPage.this.m_genericTypeField.acceptProposal(ScoutProposalUtility.getScoutTypeProposalsFor(ScoutSdk.getType((String)Long.class.getName()))[0]);
                        }
                    } else {
                        CodeTypeNewWizardPage.this.m_genericTypeField.setEnabled(false);
                    }
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField(parent, this.getSharedBundle(), "Generic Type");
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(this.getSuperType() != null && TypeUtility.isGenericType((IType)this.getSuperType().getType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    CodeTypeNewWizardPage.this.m_genericSignature = (SignatureProposal)event.proposal;
                    if (CodeTypeNewWizardPage.this.m_genericSignature != null && CodeTypeNewWizardPage.this.getNextCodeId() == null) {
                        CodeTypeNewWizardPage.this.setNextCodeId(CodeIdExtensionPoint.getNextCodeId(CodeTypeNewWizardPage.this.getSharedBundle().getScoutProject(), CodeTypeNewWizardPage.this.getGenericSignature().getSignature()));
                    }
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nextCodeIdField.setLayoutData(new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        ITypeProposal superTypeProp;
        CodeTypeNewOperation op = new CodeTypeNewOperation();
        op.setSharedBundle(this.getSharedBundle());
        op.setTypeName(this.getTypeName());
        if (this.getNlsName() != null) {
            op.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        if ((superTypeProp = this.getSuperType()) != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? Signature.createTypeSignature((String)(String.valueOf(superTypeProp.getType().getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature().getSignature()) + ">"), (boolean)true) : Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true);
            op.setSuperTypeSignature(sig);
        }
        op.setNextCodeId(this.getNextCodeId());
        op.setFormatSource(true);
        op.validate();
        op.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusCodeIdField());
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusGenericType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    protected IStatus getStatusCodeIdField() throws JavaModelException {
        if (!StringUtility.isNullOrEmpty((String)this.getNextCodeId())) {
            try {
                Long.parseLong(this.getNextCodeId().replaceAll("[lL]{0,1}$", ""));
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, "org.eclipse.scout.sdk", "code it must be a number (long).");
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("CodeType")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutSdk.existsType((String)(String.valueOf(this.getSharedBundle().getPackageName(".services.code")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericType() throws JavaModelException {
        if (this.getSuperType() != null && TypeUtility.isGenericType((IType)this.getSuperType().getType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "Generic type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public void setNextCodeId(String nextCodeId) {
        try {
            this.setStateChanging(true);
            this.m_nextCodeId = nextCodeId;
            if (this.isControlCreated()) {
                this.m_nextCodeIdField.setText(nextCodeId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getNextCodeId() {
        return this.m_nextCodeId;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(SignatureProposal genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SignatureProposal getGenericSignature() {
        return this.m_genericSignature;
    }
}

