/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.FormStackNewOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.FormNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class FormNewWizardPage
extends AbstractWorkspaceWizardPage {
    private static final IType iForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
    private static final IType abstractForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.AbstractForm");
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_CREATE_FORM_ID = "createFormId";
    public static final String PROP_FORM_ID_NAME = "formIdName";
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private Button m_createFormIdField;
    private StyledTextField m_formIdField;
    private IScoutBundle m_clientBundle;

    public FormNewWizardPage(IScoutBundle clientBundle) {
        super(FormNewWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle("Form");
        this.setDefaultMessage("Create a new form.");
        this.setSuperTypeInternal(ScoutProposalUtility.getScoutTypeProposalsFor(abstractForm)[0]);
        this.setCreateFormId(true);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, null, "Name");
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    FormNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (FormNewWizardPage.this.getNlsName() != null) {
                        oldEntry = FormNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    NlsProposal newName = (NlsProposal)event.proposal;
                    FormNewWizardPage.this.setNlsNameInternal(newName);
                    if (newName != null) {
                        if (StringUtility.isNullOrEmpty((String)FormNewWizardPage.this.m_typeNameField.getModifiableText()) || oldEntry.getKey().equals(FormNewWizardPage.this.m_typeNameField.getModifiableText())) {
                            FormNewWizardPage.this.m_typeNameField.setText(newName.getNlsEntry().getKey());
                        }
                        if (StringUtility.isNullOrEmpty((String)FormNewWizardPage.this.m_formIdField.getModifiableText()) || oldEntry.getKey().equals(FormNewWizardPage.this.m_formIdField.getModifiableText())) {
                            FormNewWizardPage.this.m_formIdField.setText(newName.getNlsEntry().getKey());
                        }
                    }
                }
                finally {
                    FormNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Form");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormNewWizardPage.this.setTypeNameInternal(FormNewWizardPage.this.m_typeNameField.getText());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, null, "Super Type");
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                FormNewWizardPage.this.setSuperTypeInternal((ITypeProposal)event.proposal);
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        Control formIdGroup = this.createIdGroup(parent);
        this.updateClientBundle();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        formIdGroup.setLayoutData((Object)new GridData(768));
    }

    protected Control createIdGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Form ID");
        this.m_createFormIdField = new Button((Composite)group, 32);
        this.m_createFormIdField.setText("Create form ID");
        this.m_createFormIdField.setSelection(this.isCreateFormId());
        this.m_createFormIdField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setCreateFormIdInternal(FormNewWizardPage.this.m_createFormIdField.getSelection());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_formIdField = this.getFieldToolkit().createStyledTextField((Composite)group, "Property name ID");
        this.m_formIdField.setReadOnlySuffix("Nr");
        this.m_formIdField.setText(this.getTypeName());
        this.m_formIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormNewWizardPage.this.setFormIdInternal(FormNewWizardPage.this.m_formIdField.getText());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_createFormIdField.setLayoutData((Object)new GridData(768));
        this.m_formIdField.setLayoutData(new GridData(768));
        return group;
    }

    private void updateClientBundle() {
        DefaultProposalProvider superTypeProvider = new DefaultProposalProvider();
        INlsProject nlsProject = null;
        if (this.getClientBundle() != null) {
            nlsProject = this.getClientBundle().findBestMatchNlsProject();
            IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(abstractForm);
            IPrimaryTypeTypeHierarchy formHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)iForm);
            IType[] abstractForms = formHierarchy.getAllClasses(TypeFilters.getAbstractOnClasspath((IJavaProject)this.getClientBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
            IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(abstractForms);
            superTypeProvider = new DefaultProposalProvider(shotList, proposals);
        }
        if (nlsProject != null) {
            this.m_nlsNameField.setNlsProject(nlsProject);
        } else {
            this.m_nlsNameField.setEnabled(false);
            this.m_nlsNameField.acceptProposal(null);
        }
        ITypeProposal superTypeProp = (ITypeProposal)this.m_superTypeField.getSelectedProposal();
        this.m_superTypeField.setContentProposalProvider(superTypeProvider);
        if (superTypeProp != null && this.getClientBundle().isOnClasspath(superTypeProp.getType())) {
            this.m_superTypeField.acceptProposal(superTypeProp);
        }
    }

    void fillOperation(FormStackNewOperation operation) {
        ITypeProposal superTypeProp;
        operation.setCreateIdProperty(this.isCreateFormId());
        operation.setFormIdName(this.getFormId());
        operation.setFormName(this.getTypeName());
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        if ((superTypeProp = this.getSuperType()) != null) {
            operation.setFormSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true));
        }
    }

    public FormNewWizard getWizard() {
        return (FormNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusPropertyId());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusPropertyId() {
        if (this.isCreateFormId() && (StringUtility.isNullOrEmpty((String)this.getFormId()) || this.getFormId().equals("Nr"))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Id name is not set.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Form")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutSdk.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".ui.forms")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public void setClientBundle(IScoutBundle clientBundle) {
        this.m_clientBundle = clientBundle;
        if (this.isControlCreated()) {
            this.updateClientBundle();
        }
    }

    public NlsProposal getNlsName() {
        return (NlsProposal)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(NlsProposal proposal) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(proposal);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(proposal);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(NlsProposal proposal) {
        this.setProperty(PROP_NLS_NAME, proposal);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public ITypeProposal getSuperType() {
        return (ITypeProposal)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(ITypeProposal superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public boolean isCreateFormId() {
        return this.getPropertyBool(PROP_CREATE_FORM_ID);
    }

    public void setCreateFormId(boolean createFormId) {
        try {
            this.setStateChanging(true);
            this.setCreateFormIdInternal(createFormId);
            if (this.isControlCreated()) {
                this.m_createFormIdField.setSelection(createFormId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setCreateFormIdInternal(boolean createFormId) {
        this.setPropertyBool(PROP_CREATE_FORM_ID, createFormId);
    }

    public String getFormId() {
        return this.getPropertyString(PROP_FORM_ID_NAME);
    }

    public void setFormId(String formId) {
        try {
            this.setStateChanging(true);
            this.setFormIdInternal(formId);
            if (this.isControlCreated()) {
                this.m_formIdField.setText(formId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFormIdInternal(String formId) {
        this.setPropertyString(PROP_FORM_ID_NAME, formId);
    }
}

