/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.FormStackNewOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.SearchFormNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SearchFormNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_TABLE_PAGE = "tablePage";
    final IType iForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
    final IType iSearchForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
    final IType abstractSearchForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractSearchForm");
    final IType iPage = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage");
    final IType iPageWithTable = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_tablePageField;
    private IScoutBundle m_clientBundle;

    public SearchFormNewWizardPage(IScoutBundle clientBundle) {
        super(SearchFormNewWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle("Search Form");
        this.setDefaultMessage("Create a new search form.");
        this.setSuperTypeInternal(ScoutProposalUtility.getScoutTypeProposalsFor(this.abstractSearchForm)[0]);
    }

    @Override
    protected void createContent(Composite parent) {
        Control tablePageGroup = this.createTablePageGroup(parent);
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, null, "Name");
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SearchFormNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (SearchFormNewWizardPage.this.getNlsName() != null) {
                        oldEntry = SearchFormNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    NlsProposal newName = (NlsProposal)event.proposal;
                    SearchFormNewWizardPage.this.setNlsNameInternal(newName);
                    if (newName != null && oldEntry == null && (StringUtility.isNullOrEmpty((String)SearchFormNewWizardPage.this.m_typeNameField.getModifiableText()) || oldEntry.getKey().equals(SearchFormNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        SearchFormNewWizardPage.this.m_typeNameField.setText(newName.getNlsEntry().getKey());
                    }
                }
                finally {
                    SearchFormNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("SearchForm");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchFormNewWizardPage.this.setTypeNameInternal(SearchFormNewWizardPage.this.m_typeNameField.getText());
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, null, "Super Type");
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SearchFormNewWizardPage.this.setSuperTypeInternal((ITypeProposal)event.proposal);
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        this.updateClientBundle();
        parent.setLayout((Layout)new GridLayout(1, true));
        tablePageGroup.setLayoutData((Object)new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
    }

    private Control createTablePageGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Auto create");
        Label label = new Label((Composite)group, 0);
        label.setText("Choose a table page to create a 'Search Form' for.");
        this.m_tablePageField = this.getFieldToolkit().createProposalField((Composite)group, null, "Table Page");
        this.m_tablePageField.acceptProposal(this.getTablePageType());
        this.m_tablePageField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SearchFormNewWizardPage.this.setTablePageTypeInternal((ITypeProposal)event.proposal);
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        label.setLayoutData((Object)new GridData(768));
        this.m_tablePageField.setLayoutData(new GridData(768));
        return group;
    }

    @Override
    public void setFocus() {
        if (this.m_tablePageField.getSelectedProposal() == null) {
            this.m_tablePageField.setFocus();
        } else {
            this.m_nlsNameField.setFocus();
        }
    }

    private void updateClientBundle() {
        DefaultProposalProvider superTypeProvider = new DefaultProposalProvider();
        DefaultProposalProvider tablePageProvider = new DefaultProposalProvider();
        INlsProject nlsProject = null;
        if (this.getClientBundle() != null) {
            nlsProject = this.getClientBundle().findBestMatchNlsProject();
            IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractSearchForm"));
            IPrimaryTypeTypeHierarchy searchFormHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iSearchForm);
            IType[] abstractSearchForms = searchFormHierarchy.getAllSubtypes(this.iSearchForm, TypeFilters.getAbstractOnClasspath((IJavaProject)this.getClientBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
            IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(abstractSearchForms);
            superTypeProvider = new DefaultProposalProvider(shotList, proposals);
            IType[] pageWithTables = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iPage).getAllSubtypes(this.iPageWithTable, TypeFilters.getTypesOnClasspath((IJavaProject)this.getClientBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
            IContentProposalEx[] tpProposals = ScoutProposalUtility.getScoutTypeProposalsFor(pageWithTables);
            tablePageProvider = new DefaultProposalProvider(tpProposals);
        }
        if (nlsProject != null) {
            this.m_nlsNameField.setNlsProject(nlsProject);
        } else {
            this.m_nlsNameField.setEnabled(false);
            this.m_nlsNameField.acceptProposal(null);
        }
        ITypeProposal superTypeProp = (ITypeProposal)this.m_superTypeField.getSelectedProposal();
        this.m_superTypeField.setContentProposalProvider(superTypeProvider);
        if (superTypeProp != null && this.getClientBundle().isOnClasspath(superTypeProp.getType())) {
            this.m_superTypeField.acceptProposal(superTypeProp);
        }
        ITypeProposal tablePageTypeProp = (ITypeProposal)this.m_tablePageField.getSelectedProposal();
        this.m_tablePageField.setContentProposalProvider(tablePageProvider);
        if (tablePageTypeProp != null && this.getClientBundle().isOnClasspath(tablePageTypeProp.getType())) {
            this.m_tablePageField.acceptProposal(tablePageTypeProp);
        }
    }

    void fillOperation(FormStackNewOperation operation) {
        ITypeProposal superTypeProp;
        operation.setFormName(this.getTypeName());
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        if ((superTypeProp = this.getSuperType()) != null) {
            operation.setFormSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true));
        }
    }

    public SearchFormNewWizard getWizard() {
        return (SearchFormNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("SearchForm")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutSdk.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".ui.searchforms")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public void setClientBundle(IScoutBundle clientBundle) {
        this.m_clientBundle = clientBundle;
        if (this.isControlCreated()) {
            this.updateClientBundle();
        }
    }

    public NlsProposal getNlsName() {
        return (NlsProposal)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(NlsProposal proposal) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(proposal);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(proposal);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(NlsProposal proposal) {
        this.setProperty(PROP_NLS_NAME, proposal);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public ITypeProposal getSuperType() {
        return (ITypeProposal)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(ITypeProposal superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public ITypeProposal getTablePageType() {
        return (ITypeProposal)this.getProperty(PROP_TABLE_PAGE);
    }

    public void setTablePageType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.setTablePageTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_tablePageField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTablePageTypeInternal(ITypeProposal superType) {
        this.setProperty(PROP_TABLE_PAGE, superType);
    }
}

