/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.extensions.AbstractFormFieldWizard;
import org.eclipse.scout.sdk.ui.extensions.IFormFieldExtension;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.internal.extensions.FormFieldExtensionPoint;
import org.eclipse.scout.sdk.ui.wizard.AbstractScoutWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormFieldSelectionWizardPage
extends AbstractWorkspaceWizardPage {
    private IType iFormField = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField");
    private final IType m_declaringType;
    private AbstractScoutWizardPage m_nextPage;
    private HashSet<IFormFieldExtension> m_byExtensionEntries = new HashSet();
    private HashSet<IType> m_byClassEntries = new HashSet();
    private FilteredTable m_table;
    private Button m_allFieldsButton;
    private P_TableFilter m_tableFilter;

    public FormFieldSelectionWizardPage(IType declaringType) {
        super(FormFieldSelectionWizardPage.class.getName());
        this.m_declaringType = declaringType;
        this.setTitle("Form Field");
        this.setDefaultMessage("Select a form field super class. \nUse 'show all fields' to get all subclasses of IFormField.");
    }

    @Override
    protected void createContent(Composite parent) {
        IType[] abstractFormFields;
        IFormFieldExtension[] iFormFieldExtensionArray = FormFieldExtensionPoint.getAllFormFieldExtensions();
        int n = iFormFieldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormFieldExtension ext = iFormFieldExtensionArray[n2];
            if (ext.isInShortList() && !StringUtility.isNullOrEmpty((String)ext.getName())) {
                this.m_byExtensionEntries.add(ext);
            }
            ++n2;
        }
        IPrimaryTypeTypeHierarchy formFieldHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField"));
        IType[] iTypeArray = abstractFormFields = formFieldHierarchy.getAllSubtypes(this.iFormField, TypeFilters.getAbstractOnClasspath((IJavaProject)this.m_declaringType.getJavaProject()), TypeComparators.getOrderAnnotationComparator());
        int n3 = abstractFormFields.length;
        int n4 = 0;
        while (n4 < n3) {
            IType formField = iTypeArray[n4];
            this.m_byClassEntries.add(formField);
            ++n4;
        }
        this.m_tableFilter = new P_TableFilter();
        this.m_table = new FilteredTable(parent, 68100);
        this.m_table.getViewer().addFilter((ViewerFilter)this.m_tableFilter);
        this.m_table.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedItem = null;
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    selectedItem = selection.getFirstElement();
                }
                FormFieldSelectionWizardPage.this.handleSelection(selectedItem);
            }
        });
        this.m_table.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedItem = null;
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    selectedItem = selection.getFirstElement();
                }
                FormFieldSelectionWizardPage.this.handleSelection(selectedItem);
                IWizardPage page = FormFieldSelectionWizardPage.this.getNextPage();
                if (page == null) {
                    return;
                }
                IWizardContainer container = FormFieldSelectionWizardPage.this.getWizard().getContainer();
                if (container != null) {
                    container.showPage(page);
                }
            }
        });
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.addAll(this.m_byClassEntries);
        elements.addAll(this.m_byExtensionEntries);
        P_ContentProvider provider = new P_ContentProvider(elements.toArray());
        this.m_table.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_table.getViewer().setContentProvider((IContentProvider)provider);
        this.m_table.getViewer().setInput((Object)provider);
        this.m_allFieldsButton = new Button(parent, 32);
        this.m_allFieldsButton.setText("show all fields");
        this.m_allFieldsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormFieldSelectionWizardPage.this.showAllFields(((Button)e.widget).getSelection());
            }
        });
        this.showAllFields(false);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_table.setLayoutData(new GridData(1808));
    }

    private void handleSelection(Object selectedItem) {
        AbstractFormFieldWizard wizard = null;
        if (selectedItem instanceof IType) {
            IType selectedType = (IType)selectedItem;
            wizard = (AbstractFormFieldWizard)FormFieldExtensionPoint.createNewWizard(selectedType);
            wizard.initWizard(this.m_declaringType);
            wizard.setSuperType(selectedType);
        } else if (selectedItem instanceof IFormFieldExtension) {
            IFormFieldExtension ext = (IFormFieldExtension)selectedItem;
            wizard = (AbstractFormFieldWizard)ext.createNewWizard();
            wizard.initWizard(this.m_declaringType);
        }
        this.m_nextPage = wizard != null ? (AbstractScoutWizardPage)wizard.getPages()[0] : null;
        this.revalidate();
    }

    protected void showAllFields(boolean selection) {
        this.m_tableFilter.setByClass(selection);
        this.m_table.refresh(true);
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusFieldList());
    }

    private IStatus getStatusFieldList() {
        if (this.m_nextPage == null) {
            return new Status(4, "org.eclipse.scout.sdk", "No Field selected.");
        }
        return Status.OK_STATUS;
    }

    public IWizardPage getNextPage() {
        return this.m_nextPage;
    }

    private class P_ContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private Object[] m_elements;

        public P_ContentProvider(Object[] elements) {
            this.m_elements = elements;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_elements;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ScoutSdkUi.getImage("formField.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                String label = "";
                if (element instanceof IType) {
                    IType t = (IType)element;
                    label = t.getElementName();
                    StructuredSelection selection = (StructuredSelection)FormFieldSelectionWizardPage.this.m_table.getViewer().getSelection();
                    if (selection.toList().contains(element)) {
                        label = String.valueOf(label) + "  (" + t.getPackageFragment().getElementName() + ")";
                    }
                } else if (element instanceof IFormFieldExtension) {
                    label = ((IFormFieldExtension)element).getName();
                }
                return label;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class P_TableFilter
    extends ViewerFilter {
        private boolean m_byClass = false;

        private P_TableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.m_byClass) {
                return element instanceof IType;
            }
            return element instanceof IFormFieldExtension;
        }

        public void setByClass(boolean byClass) {
            this.m_byClass = byClass;
        }
    }
}

