/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.buttonfield;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.field.ButtonFieldNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ButtonFieldNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iButton = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.button.IButton");
    private final IType iFormField = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private SiblingProposal m_sibling;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private ButtonFieldNewOperation m_operation;
    private final String m_readOnlySuffix;
    private IType m_createdField;

    public ButtonFieldNewWizardPage(IType declaringType) {
        this(declaringType, "New ButtonField", "Create a new button field.", "Button");
    }

    public ButtonFieldNewWizardPage(IType declaringType, String title, String message, String suffix) {
        super(ButtonFieldNewWizardPage.class.getName());
        this.m_readOnlySuffix = suffix;
        this.setTitle(title);
        this.setDefaultMessage(message);
        this.m_declaringType = declaringType;
        this.setOperation(new ButtonFieldNewOperation(this.m_declaringType));
        this.setSuperType(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton"));
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, SdkTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    ButtonFieldNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (ButtonFieldNewWizardPage.this.getNlsName() != null) {
                        oldEntry = ButtonFieldNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    ButtonFieldNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (ButtonFieldNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(ButtonFieldNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)ButtonFieldNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        ButtonFieldNewWizardPage.this.m_typeNameField.setText(ButtonFieldNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    ButtonFieldNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix(this.m_readOnlySuffix);
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ButtonFieldNewWizardPage.this.m_typeName = ButtonFieldNewWizardPage.this.m_typeNameField.getText();
                ButtonFieldNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] availableSiblings = ScoutProposalUtility.getSiblingProposals(SdkTypeUtility.getFormFields((IType)this.m_declaringType));
        this.m_siblingField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(availableSiblings), "Sibling");
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.setEnabled(availableSiblings != null && availableSiblings.length > 0);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                ButtonFieldNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                ButtonFieldNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        this.getOperation().setFormatSource(true);
        if (this.getNlsName() != null) {
            this.getOperation().setNlsEntry(this.getNlsName().getNlsEntry());
        }
        this.getOperation().setTypeName(this.getTypeName());
        if (this.getSuperType() != null) {
            this.getOperation().setSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName(), (boolean)true));
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            this.getOperation().setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else {
            this.getOperation().setSibling((IJavaElement)this.getSibling().getScoutType());
        }
        this.getOperation().run(monitor, workingCopyManager);
        this.m_createdField = this.getOperation().getCreatedButton();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals(this.m_readOnlySuffix)) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.findInnerType((IType)this.m_declaringType, (String)this.getTypeName()) != null) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public void setOperation(ButtonFieldNewOperation operation) {
        this.m_operation = operation;
    }

    public ButtonFieldNewOperation getOperation() {
        return this.m_operation;
    }

    public IType getCreatedField() {
        return this.m_createdField;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
        this.pingStateChanging();
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

