/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.composerfield.tree;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.util.InnerTypeNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ComposerFieldOverrideTreeWizardPage
extends AbstractWorkspaceWizardPage {
    final IType abstractComposerField_Tree = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField.Tree");
    private String m_typeName;
    private StyledTextField m_typeNameField;
    private final IType m_declaringType;

    public ComposerFieldOverrideTreeWizardPage(IType declaringType) {
        super(ComposerFieldOverrideTreeWizardPage.class.getName());
        this.setTitle("Override Composer Field Tree");
        this.setDefaultMessage("Overrides the composer fields default tree.");
        this.m_declaringType = declaringType;
        this.setTypeName("Tree");
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Tree");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComposerFieldOverrideTreeWizardPage.this.m_typeName = ComposerFieldOverrideTreeWizardPage.this.m_typeNameField.getText();
                ComposerFieldOverrideTreeWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        InnerTypeNewOperation op = new InnerTypeNewOperation(this.getTypeName(), this.getDeclaringType());
        op.setFormatSource(true);
        op.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField.Tree", (boolean)true));
        op.validate();
        op.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Tree")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

