/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.formfield;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.field.DefaultFormFieldNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SignatureProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DefaultFormFieldNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType abstractFormField = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField");
    final IType iFormField = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private ITypeProposal m_superType;
    private SignatureProposal m_genericSignature;
    private SiblingProposal m_sibling;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private IType m_createdField;

    public DefaultFormFieldNewWizardPage(IType declaringType) {
        super("New Default Field");
        this.m_declaringType = declaringType;
        this.m_superType = ScoutProposalUtility.getScoutTypeProposalsFor(this.abstractFormField)[0];
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        this.setTitle("New DefaultFormField");
        this.setDefaultMessage("Create a new default field.");
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, SdkTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    DefaultFormFieldNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (DefaultFormFieldNewWizardPage.this.getNlsName() != null) {
                        oldEntry = DefaultFormFieldNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    DefaultFormFieldNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (DefaultFormFieldNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(DefaultFormFieldNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)DefaultFormFieldNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        DefaultFormFieldNewWizardPage.this.m_typeNameField.setText(DefaultFormFieldNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    DefaultFormFieldNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Field");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DefaultFormFieldNewWizardPage.this.m_typeName = DefaultFormFieldNewWizardPage.this.m_typeNameField.getText();
                DefaultFormFieldNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField"));
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(SdkTypeUtility.getAbstractTypesOnClasspath((IType)this.iFormField, (IJavaProject)this.m_declaringType.getJavaProject()));
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(shotList, proposals), "Super Type");
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    DefaultFormFieldNewWizardPage.this.setStateChanging(true);
                    DefaultFormFieldNewWizardPage.this.m_superType = (ITypeProposal)event.proposal;
                    if (DefaultFormFieldNewWizardPage.this.getSuperType() != null && TypeUtility.isGenericType((IType)DefaultFormFieldNewWizardPage.this.getSuperType().getType())) {
                        DefaultFormFieldNewWizardPage.this.m_genericTypeField.setEnabled(true);
                    }
                }
                finally {
                    DefaultFormFieldNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField(parent, SdkTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType), "Generic Type");
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(this.getSuperType() != null && TypeUtility.isGenericType((IType)this.getSuperType().getType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                DefaultFormFieldNewWizardPage.this.m_genericSignature = (SignatureProposal)event.proposal;
                DefaultFormFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createFormFieldSiblingProposalField(parent, this.m_declaringType);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                DefaultFormFieldNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                DefaultFormFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_sibling = (SiblingProposal)this.m_siblingField.getSelectedProposal();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        DefaultFormFieldNewOperation operation = new DefaultFormFieldNewOperation(this.m_declaringType);
        operation.setFormatSource(true);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        operation.setTypeName(this.getTypeName());
        if (this.getSuperType() != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? Signature.createTypeSignature((String)(String.valueOf(this.getSuperType().getType().getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature().getSignature()) + ">"), (boolean)true) : Signature.createTypeSignature((String)this.getSuperType().getType().getFullyQualifiedName(), (boolean)true);
            operation.setSuperTypeSignature(sig);
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else {
            operation.setSibling((IJavaElement)this.getSibling().getScoutType());
        }
        operation.run(monitor, workingCopyManager);
        this.m_createdField = operation.getCreatedField();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusGenericType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Field")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (SdkTypeUtility.getAllTypes((ICompilationUnit)this.m_declaringType.getCompilationUnit(), (ITypeFilter)TypeFilters.getRegexSimpleNameFilter((String)this.getTypeName())).length > 0) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericType() throws JavaModelException {
        if (this.getSuperType() != null && TypeUtility.isGenericType((IType)this.getSuperType().getType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "Generic type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IType getCreatedField() {
        return this.m_createdField;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(SignatureProposal genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SignatureProposal getGenericSignature() {
        return this.m_genericSignature;
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

