/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.radiobutton;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.field.RadioButtonNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RadioButtonNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType abstractRadioButton = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private ITypeProposal m_superType;
    private SiblingProposal m_sibling;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private IType m_createdRadioButton;

    public RadioButtonNewWizardPage(IType declaringType) {
        super(RadioButtonNewWizardPage.class.getName());
        this.setTitle("New Radio Button");
        this.setDefaultMessage("Create a new radio button.");
        this.m_declaringType = declaringType;
        ITypeProposal superType = this.getSuperType();
        if (superType == null) {
            superType = ScoutProposalUtility.getScoutTypeProposalsFor(this.abstractRadioButton)[0];
        }
        this.m_superType = superType;
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, SdkTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    RadioButtonNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (RadioButtonNewWizardPage.this.getNlsName() != null) {
                        oldEntry = RadioButtonNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    RadioButtonNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (RadioButtonNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(RadioButtonNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)RadioButtonNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        RadioButtonNewWizardPage.this.m_typeNameField.setText(RadioButtonNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    RadioButtonNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Button");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RadioButtonNewWizardPage.this.m_typeName = RadioButtonNewWizardPage.this.m_typeNameField.getText();
                RadioButtonNewWizardPage.this.pingStateChanging();
            }
        });
        ArrayList<IType> abstractRadioButtons = new ArrayList<IType>(Arrays.asList(SdkTypeUtility.getAbstractTypesOnClasspath((IType)this.abstractRadioButton, (IJavaProject)this.m_declaringType.getJavaProject())));
        abstractRadioButtons.add(this.abstractRadioButton);
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(abstractRadioButtons.toArray(new IType[abstractRadioButtons.size()]));
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(proposals), "Super Type");
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                RadioButtonNewWizardPage.this.m_superType = (ITypeProposal)event.proposal;
                RadioButtonNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createFormFieldSiblingProposalField(parent, this.m_declaringType);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                RadioButtonNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                RadioButtonNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_sibling = (SiblingProposal)this.m_siblingField.getSelectedProposal();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        SiblingProposal siblingProposal;
        ITypeProposal superTypeProp;
        RadioButtonNewOperation op = new RadioButtonNewOperation(this.getDeclaringType());
        op.setTypeName(this.getTypeName());
        if (this.getNlsName() != null) {
            op.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        if ((superTypeProp = this.getSuperType()) != null) {
            op.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true));
        }
        if ((siblingProposal = this.getSibling()) == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            op.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else if (siblingProposal != null) {
            op.setSibling((IJavaElement)siblingProposal.getScoutType());
        }
        op.setFormatSource(true);
        op.validate();
        op.run(monitor, workingCopyManager);
        this.m_createdRadioButton = op.getCreatedButton();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Button")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (SdkTypeUtility.getAllTypes((ICompilationUnit)this.m_declaringType.getCompilationUnit(), (ITypeFilter)TypeFilters.getRegexSimpleNameFilter((String)this.getTypeName())).length > 0) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public IType getCreatedRadioButton() {
        return this.m_createdRadioButton;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

