/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.sequencebox;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.form.field.SequenceBoxNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.extensions.AbstractFormFieldWizard;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.form.fields.sequencebox.SequenceBoxNewWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.fields.sequencebox.SequenceBoxTemplateWizardPage;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;

public class SequenceBoxNewWizard
extends AbstractFormFieldWizard {
    private SequenceBoxNewWizardPage m_page1;
    private SequenceBoxTemplateWizardPage m_templatePage;
    private SequenceBoxNewOperation m_operation;

    public SequenceBoxNewWizard() {
        this.setWindowTitle("New Sequence Box");
    }

    @Override
    public void initWizard(IType declaringType) {
        super.initWizard(declaringType);
        this.m_page1 = new SequenceBoxNewWizardPage(this.getDeclaringType());
        this.addPage((IWizardPage)this.m_page1);
        this.m_templatePage = new SequenceBoxTemplateWizardPage(this.getDeclaringType());
        this.addPage((IWizardPage)this.m_templatePage);
    }

    @Override
    public void setSuperType(IType superType) {
        this.m_page1.setSuperType(superType);
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        this.m_operation = new SequenceBoxNewOperation(this.getDeclaringType(), true);
        if (this.m_page1.getNlsName() != null) {
            this.m_operation.setNlsEntry(this.m_page1.getNlsName().getNlsEntry());
        }
        this.m_operation.setTypeName(this.m_page1.getTypeName());
        if (this.m_page1.getSuperType() != null) {
            this.m_operation.setSuperTypeSignature(Signature.createTypeSignature((String)this.m_page1.getSuperType().getFullyQualifiedName(), (boolean)true));
        }
        if (this.m_page1.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredCompositeField((IType)this.getDeclaringType());
            this.m_operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else {
            this.m_operation.setSibling((IJavaElement)this.m_page1.getSibling().getScoutType());
        }
        this.m_operation.setContentTemplate(this.m_templatePage.getSelectedTemplate());
        try {
            this.m_operation.validate();
        }
        catch (IllegalArgumentException e) {
            ScoutSdk.logWarning((String)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.run(monitor, workingCopyManager);
        }
        catch (Exception e) {
            ScoutSdk.logError((String)"could not create sequence box.", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected void postFinishDisplayThread() {
        IType createdField = this.m_operation.getCreatedField();
        if (TypeUtility.exists((IJavaElement)createdField)) {
            ScoutSdkUi.showJavaElementInEditor((IJavaElement)createdField, false);
        }
    }
}

