/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.treefield;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.field.TreeFieldNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TreeFieldNewWizardPage
extends AbstractWorkspaceWizardPage {
    private NlsProposal m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private SiblingProposal m_sibling;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_siblingField;
    private final IType m_definitionType;
    private final IType m_declaringType;
    private IType m_createdField;

    public TreeFieldNewWizardPage(IType declaringType) {
        super(TreeFieldNewWizardPage.class.getName());
        this.setTitle("New TreeField");
        this.setDefaultMessage("Create a new tree field.");
        this.m_declaringType = declaringType;
        this.m_definitionType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField");
        this.setSuperType(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField"));
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, SdkTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    TreeFieldNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (TreeFieldNewWizardPage.this.getNlsName() != null) {
                        oldEntry = TreeFieldNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    TreeFieldNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (TreeFieldNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(TreeFieldNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)TreeFieldNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        TreeFieldNewWizardPage.this.m_typeNameField.setText(TreeFieldNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    TreeFieldNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Field");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TreeFieldNewWizardPage.this.m_typeName = TreeFieldNewWizardPage.this.m_typeNameField.getText();
                TreeFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createFormFieldSiblingProposalField(parent, this.m_declaringType);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                TreeFieldNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                TreeFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_sibling = (SiblingProposal)this.m_siblingField.getSelectedProposal();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        TreeFieldNewOperation operation = new TreeFieldNewOperation(this.m_declaringType);
        operation.setFormatSource(true);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        operation.setTypeName(this.getTypeName());
        if (this.getSuperType() != null) {
            operation.setSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName(), (boolean)true));
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else {
            operation.setSibling((IJavaElement)this.getSibling().getScoutType());
        }
        operation.run(monitor, workingCopyManager);
        this.m_createdField = operation.getCreatedField();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Field")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (SdkTypeUtility.getAllTypes((ICompilationUnit)this.m_declaringType.getCompilationUnit(), (ITypeFilter)TypeFilters.getRegexSimpleNameFilter((String)this.getTypeName())).length > 0) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    public IType getCreatedField() {
        return this.m_createdField;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
        this.pingStateChanging();
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

