/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.lookupcall;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.lookupcall.LocalLookupCallNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.lookupcall.LocalLookupCallNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LocalLookupCallNewWizardPage
extends AbstractWorkspaceWizardPage {
    private static final IType localLookupCall = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall");
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private IScoutBundle m_clientBundle;

    public LocalLookupCallNewWizardPage(IScoutBundle client) {
        super(LocalLookupCallNewWizardPage.class.getName());
        this.m_clientBundle = client;
        this.setTitle("New Local Lookup Call");
        this.setDefaultMessage("Create a new local lookup call.");
        this.setLookupCallSuperTypeInternal(ScoutProposalUtility.getScoutTypeProposalsFor(localLookupCall)[0]);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("LookupCall");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalLookupCallNewWizardPage.this.setTypeNameInternal(LocalLookupCallNewWizardPage.this.m_typeNameField.getText());
                LocalLookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, null, "Lookup Call Super Type");
        IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(localLookupCall);
        IPrimaryTypeTypeHierarchy lookupServiceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)localLookupCall);
        IType[] abstractLookupServices = lookupServiceHierarchy.getAllClasses(TypeFilters.getTypesOnClasspath((IJavaProject)this.getClientBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(abstractLookupServices);
        this.m_superTypeField.setContentProposalProvider(new DefaultProposalProvider(shotList, proposals));
        this.m_superTypeField.acceptProposal(this.getLookupCallSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LocalLookupCallNewWizardPage.this.setLookupCallSuperTypeInternal((ITypeProposal)event.proposal);
                LocalLookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
    }

    public LocalLookupCallNewWizard getWizard() {
        return (LocalLookupCallNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager manager) throws CoreException {
        LocalLookupCallNewOperation op = new LocalLookupCallNewOperation();
        op.setBundle(this.getClientBundle());
        op.setLookupCallName(this.getTypeName());
        op.setFormatSource(true);
        ITypeProposal superTypeProp = this.getLookupCallSuperType();
        if (superTypeProp != null) {
            op.setLookupCallSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true));
        }
        op.validate();
        op.run(monitor, manager);
        return true;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("LookupCall")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutSdk.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".services.lookup")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getLookupCallSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public ITypeProposal getLookupCallSuperType() {
        return (ITypeProposal)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setLookupCallSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.setLookupCallSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupCallSuperTypeInternal(ITypeProposal superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }
}

