/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.lookupcall;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.operation.lookupcall.LookupCallNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.lookupcall.LookupCallNewWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;

public class LookupCallNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_LOOKUPCALL = 100;
    public static final int TYPE_SERVICE_INTERFACE = 107;
    public static final int TYPE_SERVICE_IMPLEMENTATION = 108;
    public static final int TYPE_SERVICE_REG_CLIENT = 109;
    public static final int TYPE_SERVICE_REG_SERVER = 110;
    private final IScoutBundle m_sharedBundle;
    private LookupCallNewWizardPage m_page1;
    private BundleTreeWizardPage m_page2;
    private LookupCallNewOperation m_operation;
    private ITreeNode m_locationPageRoot;

    public LookupCallNewWizard(IScoutBundle sharedBundle) {
        this.setWindowTitle("New Lookup Call");
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_sharedBundle = sharedBundle;
        this.m_page1 = new LookupCallNewWizardPage(this.getSharedBundle());
        this.addPage((IWizardPage)this.m_page1);
        this.m_locationPageRoot = this.createTree(sharedBundle);
        this.m_page2 = new BundleTreeWizardPage("Lookup Call Locations", "Use drag'n drop to organise the locations.\n Only selected items will be created.", this.m_locationPageRoot, new P_InitialCheckedFilter());
        this.m_page2.addStatusProvider(statusProvider);
        this.m_page2.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_page2);
        this.m_page1.addPropertyChangeListener(new P_LocationPropertyListener());
    }

    private ITreeNode createTree(IScoutBundle sharedBundle) {
        IScoutBundle clientBundle = null;
        IScoutBundle serverBundle = null;
        IScoutProject scoutProject = sharedBundle.getScoutProject();
        while ((clientBundle == null || serverBundle == null) && scoutProject != null) {
            clientBundle = scoutProject.getClientBundle();
            serverBundle = scoutProject.getServerBundle();
            scoutProject = scoutProject.getParentProject();
        }
        this.m_page1.setServerBundle(serverBundle);
        ITreeNode rootNode = TreeUtility.createBundleTree(sharedBundle.getScoutProject(), NodeFilters.getAcceptAll());
        if (clientBundle != null) {
            ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
            ITreeNode clientRegNode = TreeUtility.createNode(clientNode, 109, "Service Proxy Registration", ScoutSdkUi.getImageDescriptor("public_co.gif"), 109L);
            clientRegNode.setEnabled(false);
        }
        ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
        TreeUtility.createNode(sharedNode, 100, "LookupCall", ScoutSdkUi.getImageDescriptor("class_obj.gif"), 100L).setEnabled(false);
        if (serverBundle != null) {
            TreeUtility.createNode(sharedNode, 107, "IService", ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 107L).setEnabled(false);
        }
        if (serverBundle != null) {
            ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
            TreeUtility.createNode(serverNode, 108, "Service", ScoutSdkUi.getImageDescriptor("class_obj.gif"), 108L).setEnabled(false);
            TreeUtility.createNode(serverNode, 110, "Service Registration", ScoutSdkUi.getImageDescriptor("public_co.gif"), 110L).setEnabled(false);
        }
        return rootNode;
    }

    public LookupCallNewWizardPage getFormNewPage() {
        return this.m_page1;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        this.m_operation = new LookupCallNewOperation();
        this.m_operation.setInterfaceRegistrationBundle(this.m_page2.getLocationBundle(109, true, true));
        this.m_operation.setBundle(this.m_page2.getLocationBundle(100, true, true));
        this.m_operation.setFormatSource(false);
        this.m_operation.setImplementationRegistrationBundle(this.m_page2.getLocationBundle(110, true, true));
        this.m_operation.setLookupCallName(this.m_page1.getTypeName());
        this.m_operation.setServiceImplementationBundle(this.m_page2.getLocationBundle(108, true, true));
        this.m_operation.setServiceInterfaceBundle(this.m_page2.getLocationBundle(107, true, true));
        switch (this.m_page1.getLookupServiceStrategy()) {
            case CREATE_NEW: {
                ITypeProposal superTypeProp = this.m_page1.getServiceSuperType();
                if (superTypeProp == null) break;
                this.m_operation.setServiceSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true));
                break;
            }
            case USE_EXISTING: {
                ITypeProposal lookupServiceProposal = this.m_page1.getLookupServiceType();
                if (lookupServiceProposal == null) break;
                this.m_operation.setLookupService(lookupServiceProposal.getType());
            }
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("exception during perfoming finish of wizard.", e);
            return false;
        }
    }

    public LookupCallNewWizardPage getPage1() {
        return this.m_page1;
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    private class P_InitialCheckedFilter
    implements ITreeNodeFilter {
        private P_InitialCheckedFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 3: 
                case 4: 
                case 5: 
                case 100: 
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = LookupCallNewWizard.this.m_page1.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    ITreeNode serviceInterfaceNode;
                    String prefix = typeName.replaceAll("LookupCall$", "");
                    TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(100)).setText(String.valueOf(prefix) + "LookupCall");
                    ITreeNode serviceImplNode = TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(108));
                    if (serviceImplNode != null) {
                        serviceImplNode.setText(String.valueOf(prefix) + "LookupService");
                    }
                    if ((serviceInterfaceNode = TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(107))) != null) {
                        serviceInterfaceNode.setText("I" + prefix + "LookupService");
                    }
                    LookupCallNewWizard.this.m_page2.refreshTree();
                }
                LookupCallNewWizard.this.m_page2.pingStateChanging();
            } else if (evt.getPropertyName().equals("lookupServiceStrategy")) {
                LookupCallNewWizardPage.LOOKUP_SERVICE_STRATEGY strategy = LookupCallNewWizard.this.m_page1.getLookupServiceStrategy();
                switch (strategy) {
                    case CREATE_NEW: {
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(108)).setVisible(true);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(107)).setVisible(true);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(109)).setVisible(true);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(110)).setVisible(true);
                        break;
                    }
                    default: {
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(108)).setVisible(false);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(107)).setVisible(false);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(109)).setVisible(false);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(110)).setVisible(false);
                    }
                }
                LookupCallNewWizard.this.m_page2.refreshTree();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusLookupCall());
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            String fqn;
            IType interfaceType;
            ITreeNode serviceInterfaceNode;
            String fqn2;
            IType findType;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = LookupCallNewWizard.this.m_page2.getTreeNode(108, true, true)) != null && (findType = serviceImplementationBundle.findType(fqn2 = String.valueOf(serviceImplementationBundle.getPackageName(".services.process")) + "." + serviceImplNode.getText())) != null && findType.exists()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' already exists.");
            }
            IScoutBundle serviceInterfaceBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(107, true, true);
            if (serviceInterfaceBundle != null && (serviceInterfaceNode = LookupCallNewWizard.this.m_page2.getTreeNode(107, true, true)) != null && (interfaceType = serviceInterfaceBundle.findType(fqn = String.valueOf(serviceInterfaceBundle.getPackageName(".services.process")) + "." + serviceInterfaceNode.getText())) != null && interfaceType.exists()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' already exists.");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusPermission(int permissionType) {
            String fqn;
            IType permission;
            ITreeNode permissionNode;
            IScoutBundle permissionBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(permissionType, true, true);
            if (permissionBundle != null && (permissionNode = LookupCallNewWizard.this.m_page2.getTreeNode(permissionType, true, true)) != null && (permission = permissionBundle.findType(fqn = String.valueOf(permissionBundle.getPackageName(".security")) + "." + permissionNode.getText())) != null && permission.exists()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + permissionNode.getText() + "' already exists.");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusLookupCall() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle lookupCallBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(100, true, true);
            if (lookupCallBundle != null && (serviceInterfaceBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(107, true, true)) != null && !lookupCallBundle.isOnClasspath(serviceInterfaceBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + LookupCallNewWizard.this.m_page2.getTextOfNode(107) + " is not on classpath of '" + LookupCallNewWizard.this.m_page2.getTextOfNode(100) + "'.");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle serviceImplementationBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceInterfaceBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(107, true, true)) != null && !serviceImplementationBundle.isOnClasspath(serviceInterfaceBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + LookupCallNewWizard.this.m_page2.getTextOfNode(107) + " is not on classpath of '" + LookupCallNewWizard.this.m_page2.getTextOfNode(108) + "'.");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(107, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = LookupCallNewWizard.this.m_page2.getTreeNodes(109, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceInterfaceBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + LookupCallNewWizard.this.m_page2.getTextOfNode(107) + " is not on classpath of Service Registration in '" + serviceRegistrationBundle.getBundleName() + "'.");
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(108, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = LookupCallNewWizard.this.m_page2.getTreeNodes(110, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceImplementationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + LookupCallNewWizard.this.m_page2.getTextOfNode(108) + " is not on classpath of Service Registration in '" + serviceRegistrationBundle.getBundleName() + "'.");
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            switch (node.getType()) {
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            LookupCallNewWizard.this.m_page1.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 109: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }

        private void validateDropMove(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 109: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                case 108: 
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }
    }
}

