/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.lookupcall;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.lookupcall.LookupCallNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LookupCallNewWizardPage
extends AbstractWorkspaceWizardPage {
    private static final IType iLookupService = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
    private static final IType abstractSqlLookupService = ScoutSdk.getType((String)"org.eclipse.scout.rt.server.services.lookup.AbstractSqlLookupService");
    private static final IType abstractLookupService = ScoutSdk.getType((String)"org.eclipse.scout.rt.server.services.lookup.AbstractLookupService");
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SERVICE_SUPER_TYPE = "serviceSuperType";
    public static final String PROP_LOOKUP_SERVICE = "lookupService";
    public static final String PROP_LOOKUP_SERVICE_STRATEGY = "lookupServiceStrategy";
    private StyledTextField m_typeNameField;
    private Button m_createServiceButton;
    private Button m_useServiceButton;
    private Button m_noServiceButton;
    private ProposalTextField m_serviceSuperTypeField;
    private ProposalTextField m_lookupServiceTypeField;
    private IScoutBundle m_sharedBundle;
    private IScoutBundle m_serverBundle;

    public LookupCallNewWizardPage(IScoutBundle sharedBundle) {
        super(LookupCallNewWizardPage.class.getName());
        this.m_sharedBundle = sharedBundle;
        this.setTitle("New Lookup Call");
        this.setDefaultMessage("Create a new lookup call.");
        this.setLookupServiceStrategy(LOOKUP_SERVICE_STRATEGY.CREATE_NEW);
        this.setServiceSuperTypeInternal(ScoutProposalUtility.getScoutTypeProposalsFor(abstractSqlLookupService)[0]);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("LookupCall");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LookupCallNewWizardPage.this.setTypeNameInternal(LookupCallNewWizardPage.this.m_typeNameField.getText());
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        Control lookupServiceGroup = this.createLookupServiceGroup(parent);
        this.updateSharedBundle();
        this.updateServerBundle();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        lookupServiceGroup.setLayoutData((Object)new GridData(768));
    }

    protected Control createLookupServiceGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Lookup Service");
        Composite radioButtons = new Composite((Composite)group, 1);
        this.m_createServiceButton = new Button(radioButtons, 16);
        this.m_createServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.CREATE_NEW));
        this.m_createServiceButton.setText("create new lookup service");
        this.m_createServiceButton.setSelection(true);
        this.m_useServiceButton = new Button(radioButtons, 16);
        this.m_useServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.USE_EXISTING));
        this.m_useServiceButton.setText("use existing lookup service");
        this.m_noServiceButton = new Button(radioButtons, 16);
        this.m_noServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.NO_SERVICE));
        this.m_noServiceButton.setText("no lookup service");
        this.m_serviceSuperTypeField = this.getFieldToolkit().createProposalField((Composite)group, null, "Lookup Service Super Type");
        this.m_serviceSuperTypeField.acceptProposal(this.getServiceSuperType());
        this.m_serviceSuperTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LookupCallNewWizardPage.this.setServiceSuperTypeInternal((ITypeProposal)event.proposal);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_lookupServiceTypeField = this.getFieldToolkit().createProposalField((Composite)group, null, "Lookup Serivice");
        this.m_lookupServiceTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LookupCallNewWizardPage.this.setLookupServiceTypeInternal((ITypeProposal)event.proposal);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        radioButtons.setLayoutData((Object)new GridData(768));
        GridLayout radioButtonGroupLayout = new GridLayout(3, true);
        radioButtons.setLayout((Layout)radioButtonGroupLayout);
        this.m_createServiceButton.setLayoutData((Object)new GridData(768));
        this.m_useServiceButton.setLayoutData((Object)new GridData(768));
        this.m_noServiceButton.setLayoutData((Object)new GridData(768));
        this.m_serviceSuperTypeField.setLayoutData(new GridData(768));
        GridData lookupServiceData = new GridData(768);
        lookupServiceData.exclude = true;
        this.m_lookupServiceTypeField.setLayoutData(lookupServiceData);
        return group;
    }

    private void updateSharedBundle() {
        DefaultProposalProvider lookupTypeProposalProvider = new DefaultProposalProvider();
        if (this.getSharedBundle() != null) {
            IPrimaryTypeTypeHierarchy lookupServiceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)iLookupService);
            IType[] lookupServices = lookupServiceHierarchy.getAllInterfaces(TypeFilters.getTypesOnClasspath((IJavaProject)this.getSharedBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
            IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(lookupServices);
            lookupTypeProposalProvider = new DefaultProposalProvider(proposals);
        }
        ITypeProposal lookupTypeProp = (ITypeProposal)this.m_serviceSuperTypeField.getSelectedProposal();
        this.m_lookupServiceTypeField.setContentProposalProvider(lookupTypeProposalProvider);
        if (lookupTypeProp != null && this.getSharedBundle().isOnClasspath(lookupTypeProp.getType())) {
            this.m_lookupServiceTypeField.acceptProposal(lookupTypeProp);
        }
    }

    private void updateServerBundle() {
        DefaultProposalProvider superTypeProvider = new DefaultProposalProvider();
        if (this.getServerBundle() != null) {
            IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(abstractLookupService, abstractSqlLookupService);
            IPrimaryTypeTypeHierarchy lookupServiceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)iLookupService);
            IType[] abstractLookupServices = lookupServiceHierarchy.getAllClasses(TypeFilters.getAbstractOnClasspath((IJavaProject)this.getServerBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
            IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(abstractLookupServices);
            superTypeProvider = new DefaultProposalProvider(shotList, proposals);
        }
        ITypeProposal superTypeProp = (ITypeProposal)this.m_serviceSuperTypeField.getSelectedProposal();
        this.m_serviceSuperTypeField.setContentProposalProvider(superTypeProvider);
        if (superTypeProp != null && this.getServerBundle().isOnClasspath(superTypeProp.getType())) {
            this.m_serviceSuperTypeField.acceptProposal(superTypeProp);
        }
    }

    public LookupCallNewWizard getWizard() {
        return (LookupCallNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusLookupService());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("LookupCall")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutSdk.existsType((String)(String.valueOf(this.getSharedBundle().getPackageName(".services.lookup")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getLookupServiceStrategy() == LOOKUP_SERVICE_STRATEGY.CREATE_NEW && this.getServiceSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusLookupService() throws JavaModelException {
        if (this.getLookupServiceStrategy() == LOOKUP_SERVICE_STRATEGY.USE_EXISTING && this.getLookupServiceType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The lookup call can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    public void setSharedBundle(IScoutBundle sharedBundle) {
        this.m_sharedBundle = sharedBundle;
        if (this.isControlCreated()) {
            this.updateSharedBundle();
        }
    }

    public IScoutBundle getServerBundle() {
        return this.m_serverBundle;
    }

    public void setServerBundle(IScoutBundle serverBundle) {
        this.m_serverBundle = serverBundle;
        if (this.isControlCreated()) {
            this.updateServerBundle();
        }
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public LOOKUP_SERVICE_STRATEGY getLookupServiceStrategy() {
        Object strategy = this.getProperty(PROP_LOOKUP_SERVICE_STRATEGY);
        if (!(strategy instanceof LOOKUP_SERVICE_STRATEGY)) {
            strategy = LOOKUP_SERVICE_STRATEGY.NO_SERVICE;
        }
        return (LOOKUP_SERVICE_STRATEGY)((Object)strategy);
    }

    public void setLookupServiceStrategy(LOOKUP_SERVICE_STRATEGY strategy) {
        try {
            if (strategy == null) {
                strategy = LOOKUP_SERVICE_STRATEGY.NO_SERVICE;
            }
            this.setStateChanging(true);
            this.setLookupServiceStrategyInternal(strategy);
            if (this.isControlCreated()) {
                switch (strategy) {
                    case CREATE_NEW: {
                        this.m_createServiceButton.setSelection(true);
                        break;
                    }
                    case USE_EXISTING: {
                        this.m_useServiceButton.setSelection(true);
                        break;
                    }
                    case NO_SERVICE: {
                        this.m_noServiceButton.setSelection(true);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupServiceStrategyInternal(LOOKUP_SERVICE_STRATEGY strategy) {
        this.setProperty(PROP_LOOKUP_SERVICE_STRATEGY, (Object)strategy);
    }

    public ITypeProposal getServiceSuperType() {
        return (ITypeProposal)this.getProperty(PROP_SERVICE_SUPER_TYPE);
    }

    public void setServiceSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.setServiceSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_serviceSuperTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setServiceSuperTypeInternal(ITypeProposal superType) {
        this.setProperty(PROP_SERVICE_SUPER_TYPE, superType);
    }

    public ITypeProposal getLookupServiceType() {
        return (ITypeProposal)this.getProperty(PROP_LOOKUP_SERVICE);
    }

    public void setLookupServiceType(ITypeProposal lookupService) {
        try {
            this.setStateChanging(true);
            this.setLookupServiceTypeInternal(lookupService);
            if (this.isControlCreated()) {
                this.m_lookupServiceTypeField.acceptProposal(lookupService);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupServiceTypeInternal(ITypeProposal lookupService) {
        this.setProperty(PROP_LOOKUP_SERVICE, lookupService);
    }

    public static enum LOOKUP_SERVICE_STRATEGY {
        CREATE_NEW,
        USE_EXISTING,
        NO_SERVICE;

    }

    private class P_LookupServiceStrategyButtonListener
    extends SelectionAdapter {
        private final LOOKUP_SERVICE_STRATEGY m_strategy;

        public P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY strategy) {
            this.m_strategy = strategy;
        }

        public void widgetSelected(SelectionEvent e) {
            LookupCallNewWizardPage.this.setLookupServiceStrategyInternal(this.m_strategy);
            switch (this.m_strategy) {
                case CREATE_NEW: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(true);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = false;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = true;
                    break;
                }
                case USE_EXISTING: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = true;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(true);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = false;
                    break;
                }
                case NO_SERVICE: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = true;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = true;
                }
            }
            LookupCallNewWizardPage.this.m_lookupServiceTypeField.getParent().layout(true);
            LookupCallNewWizardPage.this.pingStateChanging();
        }
    }
}

