/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.menu;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.MenuNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class MenuNewWizardPage
extends AbstractWorkspaceWizardPage {
    static final String PROP_SIBLING = "sibling";
    static final String PROP_FORM_TO_OPEN = "formToOpen";
    static final String PROP_FORM_HANDLER = "formHandler";
    static IType abstractMenuType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu");
    static IType iMenuType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu");
    static IType iformType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private ITypeProposal m_superType;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_siblingField;
    private ProposalTextField m_formToOpenField;
    private ProposalTextField m_formHandlerField;
    private final IType m_declaringType;
    private IType m_createdMenu;

    public MenuNewWizardPage(IType declaringType) {
        super("New Menu");
        this.setTitle("New Menu");
        this.setDefaultMessage("Create a new menu.");
        this.m_declaringType = declaringType;
        this.m_superType = ScoutProposalUtility.getScoutTypeProposalsFor(abstractMenuType)[0];
        this.setSiblingInternal(SiblingProposal.SIBLING_END);
    }

    @Override
    protected void createContent(Composite parent) {
        IType[] innerTypes;
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, SdkTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    MenuNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (MenuNewWizardPage.this.getNlsName() != null) {
                        oldEntry = MenuNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    MenuNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (MenuNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(MenuNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)MenuNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        MenuNewWizardPage.this.m_typeNameField.setText(MenuNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    MenuNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Menu");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MenuNewWizardPage.this.m_typeName = MenuNewWizardPage.this.m_typeNameField.getText();
                MenuNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(abstractMenuType);
        IPrimaryTypeTypeHierarchy menuHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)iMenuType);
        IType[] abstractMenus = menuHierarchy.getAllSubtypes(iMenuType, TypeFilters.getAbstractOnClasspath((IJavaProject)this.getDeclaringType().getJavaProject()));
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(abstractMenus);
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(shotList, proposals), "Super Type");
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                MenuNewWizardPage.this.m_superType = (ITypeProposal)event.proposal;
                MenuNewWizardPage.this.pingStateChanging();
            }
        });
        ArrayList<SiblingProposal> availableSiblings = new ArrayList<SiblingProposal>();
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)this.getDeclaringType());
        ITypeHierarchy combinedTypeHierarchy = menuHierarchy.combinedTypeHierarchy(region);
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), TypeFilters.getSubtypeFilter((IType)iMenuType, (ITypeHierarchy)combinedTypeHierarchy)});
        IType[] iTypeArray = innerTypes = TypeUtility.getInnerTypes((IType)this.getDeclaringType(), (ITypeFilter)filter, (Comparator)TypeComparators.getOrderAnnotationComparator());
        int n = innerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType menu = iTypeArray[n2];
            availableSiblings.add(new SiblingProposal(menu));
            ++n2;
        }
        if (availableSiblings.size() > 0) {
            availableSiblings.add(SiblingProposal.SIBLING_END);
        }
        this.m_siblingField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(availableSiblings.toArray(new SiblingProposal[availableSiblings.size()])), "Sibling");
        this.m_siblingField.acceptProposal(this.getSibling());
        this.m_siblingField.setEnabled(availableSiblings.size() > 0);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                MenuNewWizardPage.this.setSiblingInternal((SiblingProposal)event.proposal);
                MenuNewWizardPage.this.pingStateChanging();
            }
        });
        Control formGroup = this.createFormGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
        formGroup.setLayoutData((Object)new GridData(768));
    }

    protected Control createFormGroup(Composite parent) {
        Group groupBox = new Group(parent, 16);
        IPrimaryTypeTypeHierarchy cachedFormHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)iformType);
        ITypeFilter formsFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getDeclaringType().getJavaProject()), TypeFilters.getClassFilter()});
        IType[] formCandidates = cachedFormHierarchy.getAllSubtypes(iformType, formsFilter, TypeComparators.getTypeNameComparator());
        IContentProposalEx[] formProposals = ScoutProposalUtility.getScoutTypeProposalsFor(formCandidates);
        this.m_formToOpenField = this.getFieldToolkit().createProposalField((Composite)groupBox, new DefaultProposalProvider(formProposals), "Form to start");
        this.m_formToOpenField.acceptProposal(this.getFormToOpen());
        this.m_formToOpenField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    MenuNewWizardPage.this.setStateChanging(true);
                    ITypeProposal formProposal = (ITypeProposal)event.proposal;
                    MenuNewWizardPage.this.setFormToOpenInternal(formProposal);
                    DefaultProposalProvider formHandlerProvider = new DefaultProposalProvider();
                    IType form = null;
                    ITypeProposal formHandlerSelection = (ITypeProposal)MenuNewWizardPage.this.m_formHandlerField.getSelectedProposal();
                    if (formProposal != null) {
                        MenuNewWizardPage.this.m_formHandlerField.setEnabled(true);
                        form = formProposal.getType();
                        IType[] formHandlers = SdkTypeUtility.getFormHandlers((IType)form);
                        if (formHandlers != null) {
                            formHandlerProvider = new DefaultProposalProvider(ScoutProposalUtility.getScoutTypeProposalsFor(formHandlers));
                        }
                        if (formHandlerSelection != null && !form.equals(formHandlerSelection.getType().getDeclaringType())) {
                            formHandlerSelection = null;
                        }
                    } else {
                        MenuNewWizardPage.this.m_formHandlerField.setEnabled(false);
                    }
                    MenuNewWizardPage.this.m_formHandlerField.setContentProposalProvider(formHandlerProvider);
                    MenuNewWizardPage.this.m_formHandlerField.acceptProposal(formHandlerSelection);
                }
                finally {
                    MenuNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_formHandlerField = this.getFieldToolkit().createProposalField((Composite)groupBox, new DefaultProposalProvider(), "Form handler");
        this.m_formHandlerField.setEnabled(false);
        this.m_formHandlerField.acceptProposal(this.getFormToOpen());
        this.m_formHandlerField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                MenuNewWizardPage.this.setFormHandlerInternal((ITypeProposal)event.proposal);
                MenuNewWizardPage.this.pingStateChanging();
            }
        });
        groupBox.setLayout((Layout)new GridLayout(1, true));
        this.m_formToOpenField.setLayoutData(new GridData(768));
        this.m_formHandlerField.setLayoutData(new GridData(768));
        return groupBox;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager manager) throws CoreException {
        MenuNewOperation operation = new MenuNewOperation(this.getDeclaringType(), true);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        operation.setTypeName(this.getTypeName());
        ITypeProposal superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            String signature = Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true);
            operation.setSuperTypeSignature(signature);
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredType((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_MENU));
        } else {
            operation.setSibling((IJavaElement)this.getSibling().getScoutType());
        }
        if (this.getFormToOpen() != null) {
            operation.setFormToOpen(this.getFormToOpen().getType());
        }
        if (this.getHandler() != null) {
            operation.setFormHandler(this.getHandler().getType());
        }
        operation.run(monitor, manager);
        this.m_createdMenu = operation.getCreatedMenu();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Menu")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.hasInnerType((IType)this.m_declaringType, (String)this.getTypeName())) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public IType getCreatedMenu() {
        return this.m_createdMenu;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SiblingProposal getSibling() {
        return (SiblingProposal)this.getProperty(PROP_SIBLING);
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.setSiblingInternal(sibling);
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSiblingInternal(SiblingProposal sibling) {
        this.setProperty(PROP_SIBLING, sibling);
    }

    public ITypeProposal getFormToOpen() {
        return (ITypeProposal)this.getProperty(PROP_FORM_TO_OPEN);
    }

    public void setFormToOpen(ITypeProposal formToOpen) {
        try {
            this.setStateChanging(true);
            this.setFormToOpenInternal(formToOpen);
            if (this.isControlCreated()) {
                this.m_formToOpenField.acceptProposal(formToOpen);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFormToOpenInternal(ITypeProposal formToOpen) {
        this.setProperty(PROP_FORM_TO_OPEN, formToOpen);
    }

    public ITypeProposal getHandler() {
        return (ITypeProposal)this.getProperty(PROP_FORM_HANDLER);
    }

    public void setFormHandler(ITypeProposal formHandler) {
        try {
            this.setStateChanging(true);
            this.setFormHandlerInternal(formHandler);
            if (this.isControlCreated()) {
                this.m_formHandlerField.acceptProposal(formHandler);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFormHandlerInternal(ITypeProposal formHandler) {
        this.setProperty(PROP_FORM_HANDLER, formHandler);
    }
}

