/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.outline;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.outline.OutlineNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class OutlineNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iOutline = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    final IType abstractOutline = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private ITypeProposal m_superType;
    private boolean m_addToDesktop;
    private boolean m_addToDesktopEnabled;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private Button m_addToDesktopField;
    private OutlineNewOperation m_operation;
    private final IScoutBundle m_clientBundle;

    public OutlineNewWizardPage(IScoutBundle clientBundle) {
        super(OutlineNewWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle("New Outline");
        this.setDefaultMessage("Create a new outline.");
        this.m_superType = ScoutProposalUtility.getScoutTypeProposalsFor(this.abstractOutline)[0];
        this.setAddToDesktopEnabled(false);
        this.setOperation(new OutlineNewOperation());
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, this.getClientBundle().findBestMatchNlsProject(), "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    OutlineNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (OutlineNewWizardPage.this.getNlsName() != null) {
                        oldEntry = OutlineNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    OutlineNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (OutlineNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(OutlineNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)OutlineNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        OutlineNewWizardPage.this.m_typeNameField.setText(OutlineNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    OutlineNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Outline");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OutlineNewWizardPage.this.m_typeName = OutlineNewWizardPage.this.m_typeNameField.getText();
                OutlineNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline"));
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(SdkTypeUtility.getAbstractTypesOnClasspath((IType)this.iOutline, (IJavaProject)this.getClientBundle().getJavaProject()));
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(shotList, proposals), "Super Type");
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                OutlineNewWizardPage.this.m_superType = (ITypeProposal)event.proposal;
                OutlineNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_addToDesktopField = new Button(parent, 32);
        this.m_addToDesktopField.setSelection(this.isAddToDesktop());
        this.m_addToDesktopField.setText("Add to Desktop");
        this.m_addToDesktopField.setEnabled(this.isAddToDesktopEnabled());
        this.m_addToDesktopField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutlineNewWizardPage.this.m_addToDesktop = OutlineNewWizardPage.this.m_addToDesktopField.getSelection();
                OutlineNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_addToDesktopField.setLayoutData((Object)new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        this.getOperation().setClientBundle(this.getClientBundle());
        if (this.getNlsName() != null) {
            this.getOperation().setNlsEntry(this.getNlsName().getNlsEntry());
        }
        this.getOperation().setTypeName(this.getTypeName());
        ITypeProposal superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            this.getOperation().setSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true));
        }
        this.getOperation().setAddToDesktop(this.isAddToDesktop());
        this.getOperation().run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public void setOperation(OutlineNewOperation operation) {
        this.m_operation = operation;
    }

    public OutlineNewOperation getOperation() {
        return this.m_operation;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Outline")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutSdk.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".ui.searchforms")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setAddToDesktop(boolean addToDesktop) {
        try {
            this.setStateChanging(true);
            this.m_addToDesktop = addToDesktop;
            if (this.isControlCreated()) {
                this.m_addToDesktopField.setSelection(addToDesktop);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public boolean isAddToDesktop() {
        return this.m_addToDesktop;
    }

    public void setAddToDesktopEnabled(boolean addToDesktopEnabled) {
        try {
            this.setStateChanging(true);
            this.m_addToDesktopEnabled = addToDesktopEnabled;
            if (this.isControlCreated()) {
                if (!addToDesktopEnabled) {
                    this.setAddToDesktop(false);
                }
                this.m_addToDesktopField.setEnabled(addToDesktopEnabled);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public boolean isAddToDesktopEnabled() {
        return this.m_addToDesktopEnabled;
    }
}

