/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.page;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.page.LinkPageOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PageLinkWizardPage
extends AbstractWorkspaceWizardPage {
    private IType iPage = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage");
    private IType iOutline = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private ITypeProposal m_holderType;
    private ITypeProposal m_pageType;
    private ProposalTextField m_holderTypeField;
    private ProposalTextField m_pageTypeField;
    private LinkPageOperation m_operation;
    private boolean m_holderTypeEnabled = true;
    private boolean m_pageTypeFieldEnabled = true;
    private IScoutBundle m_clientBundle;

    public PageLinkWizardPage(IScoutBundle clientBundle) {
        super(PageLinkWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle("Link Page");
        this.setDefaultMessage("Link page to a page holder.");
        this.setOperation(new LinkPageOperation());
    }

    @Override
    protected void createContent(Composite parent) {
        IType[] pages = SdkTypeUtility.getClassesOnClasspath((IType)this.iPage, (IJavaProject)this.getClientBundle().getJavaProject());
        this.m_pageTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(ScoutProposalUtility.getScoutTypeProposalsFor(pages)), "Page");
        this.m_pageTypeField.acceptProposal(this.getPageType());
        this.m_pageTypeField.setEnabled(this.isPageTypeFieldEnabled());
        this.m_pageTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                PageLinkWizardPage.this.setPageType((ITypeProposal)event.proposal);
                PageLinkWizardPage.this.pingStateChanging();
            }
        });
        IType[] outlines = SdkTypeUtility.getClassesOnClasspath((IType)this.iOutline, (IJavaProject)this.getClientBundle().getJavaProject());
        IType[] propTypes = new IType[pages.length + outlines.length];
        System.arraycopy(pages, 0, propTypes, 0, pages.length);
        System.arraycopy(outlines, 0, propTypes, pages.length, outlines.length);
        Arrays.sort(propTypes, TypeComparators.getTypeNameComparator());
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(propTypes);
        this.m_holderTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(proposals), "Holder Page/Outline");
        this.m_holderTypeField.acceptProposal(this.getHolderType());
        this.m_holderTypeField.setEnabled(this.isHolderTypeEnabled());
        this.m_holderTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                PageLinkWizardPage.this.m_holderType = (ITypeProposal)event.proposal;
                PageLinkWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_pageTypeField.setLayoutData(new GridData(768));
        this.m_holderTypeField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        this.getOperation().setHolderType(this.getHolderType().getType());
        this.getOperation().setPage(this.getPageType().getType());
        this.getOperation().run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        if (this.getHolderType() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", "holder type is missing."));
        } else if (this.getPageType() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", "page type is missing."));
        } else {
            multiStatus.add(Status.OK_STATUS);
        }
    }

    public void setOperation(LinkPageOperation operation) {
        this.m_operation = operation;
    }

    public LinkPageOperation getOperation() {
        return this.m_operation;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public void setHolderType(ITypeProposal holderPage) {
        try {
            this.setStateChanging(true);
            this.m_holderType = holderPage;
            if (this.isControlCreated()) {
                this.m_holderTypeField.acceptProposal(holderPage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getHolderType() {
        return this.m_holderType;
    }

    public void setHolderTypeEnabled(boolean hoderTypeEnabled) {
        if (this.isControlCreated()) {
            throw new IllegalStateException("control already created.");
        }
        this.m_holderTypeEnabled = hoderTypeEnabled;
    }

    public boolean isHolderTypeEnabled() {
        return this.m_holderTypeEnabled;
    }

    public void setPageType(ITypeProposal pageType) {
        try {
            this.setStateChanging(true);
            this.m_pageType = pageType;
            if (this.isControlCreated()) {
                this.m_pageTypeField.acceptProposal(pageType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getPageType() {
        return this.m_pageType;
    }

    public void setPageTypeFieldEnabled(boolean pageTypeFieldEnabled) {
        this.m_pageTypeFieldEnabled = pageTypeFieldEnabled;
    }

    public boolean isPageTypeFieldEnabled() {
        return this.m_pageTypeFieldEnabled;
    }
}

