/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.page;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.page.PageNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PageNewAttributesWizardPage
extends AbstractWorkspaceWizardPage {
    private IType iPage = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage");
    private IType iPageWithNodes = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes");
    private IType iPageWithTable = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
    private IType iOutline = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private ITypeProposal m_holderType;
    private String m_nameSuffix;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_holderTypeField;
    private PageNewOperation m_operation;
    private boolean m_hoderTypeEnabled = true;
    private IScoutBundle m_clientBundle;

    public PageNewAttributesWizardPage() {
        super(PageNewAttributesWizardPage.class.getName());
        this.setTitle("New Page");
        this.setDefaultMessage("Create a new page.");
        this.m_nameSuffix = "";
        this.setSuperType(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes"));
        this.setOperation(new PageNewOperation(true));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, null, "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    PageNewAttributesWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (PageNewAttributesWizardPage.this.getNlsName() != null) {
                        oldEntry = PageNewAttributesWizardPage.this.getNlsName().getNlsEntry();
                    }
                    PageNewAttributesWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (PageNewAttributesWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(PageNewAttributesWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)PageNewAttributesWizardPage.this.m_typeNameField.getModifiableText()))) {
                        PageNewAttributesWizardPage.this.m_typeNameField.setText(PageNewAttributesWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    PageNewAttributesWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix(this.m_nameSuffix);
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageNewAttributesWizardPage.this.m_typeName = PageNewAttributesWizardPage.this.m_typeNameField.getText();
                PageNewAttributesWizardPage.this.pingStateChanging();
            }
        });
        Control parentPageControl = this.createParentPageGroup(parent);
        this.updateUiField(this.getClientBundle());
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        parentPageControl.setLayoutData((Object)new GridData(768));
    }

    protected Control createParentPageGroup(Composite parent) {
        Group group = new Group(parent, 64);
        group.setText("Add to");
        this.m_holderTypeField = this.getFieldToolkit().createProposalField((Composite)group, null, "Page/Outline");
        this.m_holderTypeField.acceptProposal(this.getHolderType());
        this.m_holderTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                PageNewAttributesWizardPage.this.m_holderType = (ITypeProposal)event.proposal;
                PageNewAttributesWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_holderTypeField.setLayoutData(new GridData(768));
        return group;
    }

    private void updateUiField(IScoutBundle clientBundle) {
        INlsProject nlsProject = null;
        DefaultProposalProvider holderTypePropProvider = null;
        if (clientBundle != null) {
            nlsProject = clientBundle.findBestMatchNlsProject();
            ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getClientBundle()}), TypeFilters.getClassFilter()});
            IType[] pages = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iPage).getAllSubtypes(this.iPageWithNodes, filter);
            IType[] outlines = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iOutline).getAllSubtypes(this.iOutline, filter);
            IType[] propTypes = new IType[pages.length + outlines.length];
            System.arraycopy(pages, 0, propTypes, 0, pages.length);
            System.arraycopy(outlines, 0, propTypes, pages.length, outlines.length);
            Arrays.sort(propTypes, TypeComparators.getTypeNameComparator());
            IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(propTypes);
            holderTypePropProvider = new DefaultProposalProvider(proposals);
        }
        this.m_nlsNameField.setNlsProject(nlsProject);
        IContentProposalEx selectedProposal = this.m_holderTypeField.getSelectedProposal();
        this.m_holderTypeField.setContentProposalProvider(holderTypePropProvider);
        this.m_holderTypeField.acceptProposal(selectedProposal);
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        this.getOperation().setClientBundle(this.getClientBundle());
        if (this.getNlsName() != null) {
            this.getOperation().setNlsEntry(this.getNlsName().getNlsEntry());
        }
        this.getOperation().setTypeName(this.getTypeName());
        IType superType = this.getSuperType();
        if (superType != null) {
            this.getOperation().setSuperTypeSignature(Signature.createTypeSignature((String)superType.getFullyQualifiedName(), (boolean)true));
        }
        if (this.getHolderType() != null) {
            this.getOperation().setHolderType(this.getHolderType().getType());
        }
        this.getOperation().run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusClientBundle());
            if (!multiStatus.matches(4)) {
                multiStatus.add(this.getStatusNameField());
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusClientBundle() throws JavaModelException {
        if (this.getClientBundle() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "client bundle missing");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals(this.m_nameSuffix)) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutSdk.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".ui.desktop.outlines.pages")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    public void setOperation(PageNewOperation operation) {
        this.m_operation = operation;
    }

    public PageNewOperation getOperation() {
        return this.m_operation;
    }

    public void setClientBundle(IScoutBundle clientBundle) {
        try {
            this.setStateChanging(true);
            this.m_clientBundle = clientBundle;
            if (this.isControlCreated()) {
                this.updateUiField(clientBundle);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (TypeUtility.exists((IJavaElement)superType)) {
                try {
                    ITypeHierarchy superTypeHierarchy = superType.newSupertypeHierarchy(null);
                    this.m_nameSuffix = superTypeHierarchy.contains(this.iPageWithNodes) ? "NodePage" : (superTypeHierarchy.contains(this.iPageWithTable) ? "TablePage" : "Page");
                }
                catch (JavaModelException javaModelException) {
                    ScoutSdkUi.logError("could not create superTypeHierarchy of '" + this.getSuperType().getFullyQualifiedName() + "'.");
                }
            }
            if (this.isControlCreated()) {
                this.m_typeNameField.setReadOnlySuffix(this.m_nameSuffix);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setHolderType(ITypeProposal holderPage) {
        try {
            this.setStateChanging(true);
            this.m_holderType = holderPage;
            if (this.isControlCreated()) {
                this.m_holderTypeField.acceptProposal(holderPage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getHolderType() {
        return this.m_holderType;
    }

    public void setHoderTypeEnabled(boolean hoderTypeEnabled) {
        if (this.isControlCreated()) {
            throw new IllegalStateException("control already created.");
        }
        this.m_hoderTypeEnabled = hoderTypeEnabled;
    }

    public boolean isHoderTypeEnabled() {
        return this.m_hoderTypeEnabled;
    }
}

