/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ServiceNewWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class ClientServiceNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_SERVICE_INTERFACE = 107;
    public static final int TYPE_SERVICE_IMPLEMENTATION = 108;
    public static final int TYPE_SERVICE_REGISTRATION = 109;
    private BundleTreeWizardPage m_locationWizardPage;
    private ServiceNewWizardPage m_serviceNewWizardPage;
    private ServiceNewOperation m_operation = new ServiceNewOperation();
    private ITreeNode m_locationPageRoot;

    public ClientServiceNewWizard(IScoutBundle clientBundle) {
        this.setWindowTitle("New Clientside Service");
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_serviceNewWizardPage = new ServiceNewWizardPage("Client Service", "Create a new client service", ScoutSdk.getType((String)"org.eclipse.scout.service.IService"), "Service");
        this.m_serviceNewWizardPage.setLocationBundle(clientBundle);
        this.m_serviceNewWizardPage.addStatusProvider(statusProvider);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.m_locationPageRoot = this.createTree(clientBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage("Service Location", "Use drag'n drop to organise the locations.\n Only selected items will be created.", this.m_locationPageRoot, NodeFilters.getByData(null));
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(ScoutProposalUtility.getScoutTypeProposalsFor(ScoutSdk.getType((String)"org.eclipse.scout.service.AbstractService"))[0]);
    }

    private ITreeNode createTree(IScoutBundle clientBundle) {
        ITreeNode rootNode = TreeUtility.createBundleTree(clientBundle.getScoutProject(), NodeFilters.getByType(3));
        ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
        TreeUtility.createNode(clientNode, 109, "Service Registration", ScoutSdkUi.getImageDescriptor("public_co.gif"), 108L);
        TreeUtility.createNode(clientNode, 107, "IService", ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 107L);
        TreeUtility.createNode(clientNode, 108, "Service", ScoutSdkUi.getImageDescriptor("class_obj.gif"), 108L);
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle interfaceBundle;
        IScoutBundle implementationBundle = this.m_locationWizardPage.getLocationBundle(108, true, true);
        if (implementationBundle != null) {
            this.m_operation.setImplementationBundle(implementationBundle);
            this.m_operation.setServicePackageName(implementationBundle.getPackageName(".services"));
        }
        if ((interfaceBundle = this.m_locationWizardPage.getLocationBundle(107, true, true)) != null) {
            this.m_operation.setInterfaceBundle(interfaceBundle);
            this.m_operation.setServiceInterfacePackageName(interfaceBundle.getPackageName(".services"));
        }
        this.m_operation.setServiceInterfaceName(this.m_locationWizardPage.getTextOfNode(107, true, true));
        this.m_operation.setServiceInterfaceSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.service.IService", (boolean)true));
        ITypeProposal superType = this.m_serviceNewWizardPage.getSuperType();
        if (superType != null) {
            this.m_operation.setServiceSuperTypeSignature(Signature.createTypeSignature((String)superType.getType().getFullyQualifiedName(), (boolean)true));
        }
        this.m_operation.setServiceName(this.m_locationWizardPage.getTextOfNode(108, true, true));
        IScoutBundle[] iScoutBundleArray = this.m_locationWizardPage.getLocationBundles(109, true, true);
        int n = iScoutBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle sb = iScoutBundleArray[n2];
            this.m_operation.addServiceRegistrationBundle(sb);
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = ClientServiceNewWizard.this.m_serviceNewWizardPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    String prefix = typeName.replaceAll("Service$", "");
                    TreeUtility.findNode(ClientServiceNewWizard.this.m_locationPageRoot, NodeFilters.getByType(108)).setText(String.valueOf(prefix) + "Service");
                    TreeUtility.findNode(ClientServiceNewWizard.this.m_locationPageRoot, NodeFilters.getByType(107)).setText("I" + prefix + "Service");
                    ClientServiceNewWizard.this.m_locationWizardPage.refreshTree();
                }
                ClientServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
                ClientServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
            }
        }
    }

    private class P_NodeFilter
    implements ITreeNodeFilter {
        private P_NodeFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 107: 
                case 108: 
                case 109: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusTypeNames());
            multiStatus.add(this.getStatusServiceRegistration());
            multiStatus.add(this.getStatusService());
        }

        protected IStatus getStatusTypeNames() {
            String fqn;
            ITreeNode serviceInterfaceNode;
            String fqn2;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = ClientServiceNewWizard.this.m_locationWizardPage.getTreeNode(108, true, true)) != null && serviceImplementationBundle.findType(fqn2 = String.valueOf(serviceImplementationBundle.getPackageName(".services")) + "." + serviceImplNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' already exists.");
            }
            IScoutBundle serviceInterfaceBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true);
            if (serviceInterfaceBundle != null && (serviceInterfaceNode = ClientServiceNewWizard.this.m_locationWizardPage.getTreeNode(107, true, true)) != null && serviceInterfaceBundle.findType(fqn = String.valueOf(serviceInterfaceBundle.getPackageName(".services")) + "." + serviceInterfaceNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' already exists.");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle serviceImplementationBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceInterfaceBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true)) != null && !serviceImplementationBundle.isOnClasspath(serviceInterfaceBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + ClientServiceNewWizard.this.m_locationWizardPage.getTextOfNode(107) + " is not on classpath of '" + ClientServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108) + "'.");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistration() {
            ITreeNode[] registrationNodes;
            IScoutBundle serviceInterfaceBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(107, true, true);
            ITreeNode[] iTreeNodeArray = registrationNodes = ClientServiceNewWizard.this.m_locationWizardPage.getTreeNodes(109, true, true);
            int n = registrationNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceInterfaceBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + ClientServiceNewWizard.this.m_locationWizardPage.getTextOfNode(107) + " is not on classpath of Service Registration in '" + serviceRegistrationBundle.getBundleName() + "'.");
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            switch (node.getType()) {
                case 107: 
                case 108: 
                case 109: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        private void validateDropCopy(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 109: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }

        private void validateDropMove(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 107: 
                case 108: 
                case 109: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 3;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            ClientServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }
    }
}

