/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.service.ProcessServiceNewOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ProcessServiceNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_FORM_DATA_TYPE = "formDataType";
    final IType iService = ScoutSdk.getType((String)"org.eclipse.scout.service.IService");
    final IType abstractFormData = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.data.form.AbstractFormData");
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_formDataTypeField;
    private IScoutBundle m_serverBundle;

    public ProcessServiceNewWizardPage() {
        super(ProcessServiceNewWizardPage.class.getName());
        this.setTitle("New Process Service");
        this.setDefaultMessage("create a new Process Service.");
    }

    @Override
    protected void createContent(Composite parent) {
        IContentProposalEx[] proposals;
        ITypeFilter filter;
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("ProcessService");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessServiceNewWizardPage.this.setTypeNameInternal(ProcessServiceNewWizardPage.this.m_typeNameField.getText());
                ProcessServiceNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, null, "Super Type");
        if (this.getServerBundle() != null) {
            IPrimaryTypeTypeHierarchy serviceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iService);
            filter = TypeFilters.getAbstractOnClasspath((IJavaProject)this.getServerBundle().getJavaProject());
            IType[] abstractServices = serviceHierarchy.getAllSubtypes(this.iService, filter, TypeComparators.getTypeNameComparator());
            proposals = ScoutProposalUtility.getScoutTypeProposalsFor(abstractServices);
            this.m_superTypeField.setContentProposalProvider(new DefaultProposalProvider(proposals));
        }
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                ProcessServiceNewWizardPage.this.setSuperTypeInternal((ITypeProposal)event.proposal);
                ProcessServiceNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_formDataTypeField = this.getFieldToolkit().createProposalField(parent, null, "FormData");
        if (this.getServerBundle() != null) {
            IPrimaryTypeTypeHierarchy formDataHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.abstractFormData);
            filter = TypeFilters.getTypesOnClasspath((IJavaProject)this.getServerBundle().getJavaProject());
            IType[] abstractFormDatas = formDataHierarchy.getAllSubtypes(this.abstractFormData, filter, TypeComparators.getTypeNameComparator());
            proposals = ScoutProposalUtility.getScoutTypeProposalsFor(abstractFormDatas);
            this.m_formDataTypeField.setContentProposalProvider(new DefaultProposalProvider(proposals));
        }
        this.m_formDataTypeField.acceptProposal(this.getFormDataType());
        this.m_formDataTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                ProcessServiceNewWizardPage.this.setFormDataTypeInternal((ITypeProposal)event.proposal);
                ProcessServiceNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        GridData formDataTypeFieldData = new GridData(768);
        this.m_formDataTypeField.setLayoutData(formDataTypeFieldData);
    }

    void fillProcessServiceNewOperation(ProcessServiceNewOperation op) {
        op.setServiceImplementationName(this.getTypeName());
        op.setServiceInterfaceName("I" + this.getTypeName());
        if (this.getFormDataType() != null) {
            op.setFormData(this.getFormDataType().getType());
        }
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("ProcessService")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getServerBundle() {
        return this.m_serverBundle;
    }

    public void setServerBundle(IScoutBundle serverBundle) {
        this.m_serverBundle = serverBundle;
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public ITypeProposal getSuperType() {
        return (ITypeProposal)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSuperTypeInternal(ITypeProposal superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public void setFormDataType(ITypeProposal formDataType) {
        try {
            this.setStateChanging(true);
            this.setFormDataTypeInternal(formDataType);
            if (this.isControlCreated()) {
                this.m_formDataTypeField.acceptProposal(formDataType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setFormDataTypeInternal(ITypeProposal formDatatype) {
        this.setProperty(PROP_FORM_DATA_TYPE, formDatatype);
    }

    public ITypeProposal getFormDataType() {
        return (ITypeProposal)this.getProperty(PROP_FORM_DATA_TYPE);
    }
}

