/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ServiceNewWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class SmtpServiceNewWizard
extends AbstractWorkspaceWizard {
    public static final int TYPE_SERVICE_IMPLEMENTATION = 108;
    public static final int TYPE_SERVICE_REG_SERVER = 110;
    private final IScoutBundle m_serverBundle;
    private ServiceNewWizardPage m_serviceNewWizardPage;
    private BundleTreeWizardPage m_locationWizardPage;
    private ITreeNode m_locationWizardPageRoot;
    private ServiceNewOperation m_operation = new ServiceNewOperation();

    public SmtpServiceNewWizard(IScoutBundle serverBundle) {
        this.m_serverBundle = serverBundle;
        this.setWindowTitle("New Smtp Service");
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_serviceNewWizardPage = new ServiceNewWizardPage("New SMTP Service", "create a new smtp service.", ScoutSdk.getType((String)"org.eclipse.scout.rt.server.services.common.smtp.ISMTPService"), "SmtpService");
        this.m_serviceNewWizardPage.setLocationBundle(serverBundle);
        this.m_serviceNewWizardPage.addStatusProvider(statusProvider);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.m_locationWizardPageRoot = this.createTree(serverBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage("SMTP Service Location", "Use drag'n drop to organise the locations.\n Only selected items will be created.", this.m_locationWizardPageRoot, new P_InitialCheckerFilter());
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(ScoutProposalUtility.getScoutTypeProposalsFor(ScoutSdk.getType((String)"org.eclipse.scout.rt.server.services.common.smtp.AbstractSMTPService"))[0]);
    }

    private ITreeNode createTree(IScoutBundle serverBundle) {
        ITreeNode rootNode = TreeUtility.createBundleTree(serverBundle.getScoutProject(), NodeFilters.getAcceptAll());
        ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
        TreeUtility.createNode(serverNode, 108, "Service", ScoutSdkUi.getImageDescriptor("class_obj.gif"), 108L);
        TreeUtility.createNode(serverNode, 110, "Service Registration", ScoutSdkUi.getImageDescriptor("public_co.gif"), 110L);
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle[] serverRegBundles;
        IScoutBundle implementationBundle;
        this.m_operation.setServiceInterfaceSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.server.services.common.smtp.ISMTPService", (boolean)true));
        ITypeProposal superType = this.m_serviceNewWizardPage.getSuperType();
        if (superType != null) {
            this.m_operation.setServiceSuperTypeSignature(Signature.createTypeSignature((String)superType.getType().getFullyQualifiedName(), (boolean)true));
        }
        if ((implementationBundle = this.m_locationWizardPage.getLocationBundle(108, true, true)) != null) {
            this.m_operation.setImplementationBundle(implementationBundle);
            this.m_operation.setServicePackageName(implementationBundle.getPackageName(".services.common"));
            this.m_operation.setServiceName(this.m_locationWizardPage.getTextOfNode(108, true, true));
        }
        IScoutBundle[] iScoutBundleArray = serverRegBundles = this.m_locationWizardPage.getLocationBundles(110, true, true);
        int n = serverRegBundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle sb = iScoutBundleArray[n2];
            this.m_operation.addServiceRegistrationBundle(sb);
            ++n2;
        }
        this.m_operation.setServiceInterfaceSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.server.services.common.smtp.ISMTPService", (boolean)true));
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_InitialCheckerFilter
    implements ITreeNodeFilter {
        private P_InitialCheckerFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 108: 
                case 110: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = SmtpServiceNewWizard.this.m_serviceNewWizardPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    String prefix = typeName.replaceAll("SmtpService$", "");
                    TreeUtility.findNode(SmtpServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(108)).setText(String.valueOf(prefix) + "SmtpService");
                    SmtpServiceNewWizard.this.m_locationWizardPage.refreshTree();
                }
                SmtpServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            String fqn;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = SmtpServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = SmtpServiceNewWizard.this.m_locationWizardPage.getTreeNode(108, true, true)) != null && serviceImplementationBundle.findType(fqn = String.valueOf(serviceImplementationBundle.getPackageName(".services.common")) + "." + serviceImplNode.getText()) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' already exists.");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = SmtpServiceNewWizard.this.m_locationWizardPage.getLocationBundle(108, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = SmtpServiceNewWizard.this.m_locationWizardPage.getTreeNodes(110, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !serviceRegistrationBundle.isOnClasspath(serviceImplementationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + SmtpServiceNewWizard.this.m_locationWizardPage.getTextOfNode(108) + " is not on classpath of Service Registration in '" + serviceRegistrationBundle.getBundleName() + "'.");
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            switch (node.getType()) {
                case 108: 
                case 110: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            SmtpServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }

        private void validateDropMove(DndEvent dndEvent) {
            switch (dndEvent.node.getType()) {
                case 108: 
                case 110: {
                    dndEvent.doit = dndEvent.targetParent.getType() == 5;
                    break;
                }
                default: {
                    dndEvent.doit = false;
                }
            }
        }
    }
}

