/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.tablecolumn;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.TableColumnNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SignatureProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DefaultTableColumnNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iColumn = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private SignatureProposal m_genericSignature;
    private SiblingProposal m_sibling;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private IType m_superType;
    private IType m_createdColumn;

    public DefaultTableColumnNewWizardPage(IType declaringType) {
        super("New Table Column");
        this.setTitle("New Table Column");
        this.setDefaultMessage("Create a new table column");
        this.m_genericSignature = new SignatureProposal(Signature.createTypeSignature((String)Long.class.getName(), (boolean)true));
        this.m_declaringType = declaringType;
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, null, "Name");
        INlsProject nlsProject = SdkTypeUtility.findNlsProject((IJavaElement)this.m_declaringType);
        if (nlsProject != null) {
            this.m_nlsNameField.setNlsProject(nlsProject);
        } else {
            this.m_nlsNameField.setEnabled(false);
        }
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    DefaultTableColumnNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (DefaultTableColumnNewWizardPage.this.getNlsName() != null) {
                        oldEntry = DefaultTableColumnNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    DefaultTableColumnNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (DefaultTableColumnNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(DefaultTableColumnNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)DefaultTableColumnNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        DefaultTableColumnNewWizardPage.this.m_typeNameField.setText(DefaultTableColumnNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    DefaultTableColumnNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Column");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DefaultTableColumnNewWizardPage.this.m_typeName = DefaultTableColumnNewWizardPage.this.m_typeNameField.getText();
                DefaultTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField(parent, SdkTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType), "Generic Type");
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                DefaultTableColumnNewWizardPage.this.m_genericSignature = (SignatureProposal)event.proposal;
                DefaultTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] availableSiblings = ScoutProposalUtility.getSiblingProposals(SdkTypeUtility.getColumns((IType)this.m_declaringType));
        this.m_siblingField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(availableSiblings), "Sibling");
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.setEnabled(availableSiblings != null && availableSiblings.length > 0);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                DefaultTableColumnNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                DefaultTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        TableColumnNewOperation operation = new TableColumnNewOperation(this.m_declaringType, true);
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? Signature.createTypeSignature((String)(String.valueOf(superTypeProp.getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature().getSignature()) + ">"), (boolean)true) : Signature.createTypeSignature((String)superTypeProp.getFullyQualifiedName(), (boolean)true);
            operation.setSuperTypeSignature(sig);
        }
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        operation.setTypeName(this.getTypeName());
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredTable((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_COLUMN));
        } else {
            operation.setSibling((IJavaElement)this.getSibling().getScoutType());
        }
        operation.run(monitor, workingCopyManager);
        this.m_createdColumn = operation.getCreatedColumn();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusGenericType());
            if (this.isControlCreated()) {
                this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Column")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    public IType getCreatedColumn() {
        return this.m_createdColumn;
    }

    protected IStatus getStatusGenericType() throws JavaModelException {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "Generic type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            if (TypeUtility.isGenericType((IType)this.getSuperType())) {
                this.setGenericSignature(new SignatureProposal(Signature.createTypeSignature((String)Long.class.getName(), (boolean)true)));
            } else {
                this.setGenericSignature(null);
            }
            this.m_superType = superType;
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(SignatureProposal genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SignatureProposal getGenericSignature() {
        return this.m_genericSignature;
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

