/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.toolbutton;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.OutlineToolbuttonNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.ScoutTypeProposalProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.toolbutton.ToolbuttonNewWizardPage1;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class OutlineToolbuttonNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iToolButton = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.tool.IToolButton");
    final IType iOutline = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private ITypeProposal m_outline;
    private String m_typeName;
    private SiblingProposal m_sibling;
    private ProposalTextField m_outlineField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;

    public OutlineToolbuttonNewWizardPage(IType declaringType) {
        super(OutlineToolbuttonNewWizardPage.class.getName());
        this.setTitle("New Outline Tool Button");
        this.setDefaultMessage("Create a new outline tool button.");
        this.m_declaringType = declaringType;
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        IContentProposalEx[] outlineProposals = ScoutProposalUtility.getScoutTypeProposalsFor(SdkTypeUtility.getClassesOnClasspath((IType)this.iOutline, (IJavaProject)this.m_declaringType.getJavaProject()));
        this.m_outlineField = this.getFieldToolkit().createProposalField(parent, new ScoutTypeProposalProvider(outlineProposals), "Outline");
        this.m_outlineField.acceptProposal(this.getOutline());
        this.m_outlineField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    OutlineToolbuttonNewWizardPage.this.setStateChanging(true);
                    OutlineToolbuttonNewWizardPage.this.m_outline = (ITypeProposal)event.proposal;
                    if (OutlineToolbuttonNewWizardPage.this.getOutline() != null && StringUtility.isNullOrEmpty((String)OutlineToolbuttonNewWizardPage.this.m_typeNameField.getModifiableText())) {
                        OutlineToolbuttonNewWizardPage.this.m_typeNameField.setText(OutlineToolbuttonNewWizardPage.this.getOutline().getType().getElementName());
                    }
                }
                finally {
                    OutlineToolbuttonNewWizardPage.this.setStateChanging(false);
                }
                OutlineToolbuttonNewWizardPage.this.setOutline((ITypeProposal)event.proposal);
                OutlineToolbuttonNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Tool");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OutlineToolbuttonNewWizardPage.this.m_typeName = OutlineToolbuttonNewWizardPage.this.m_typeNameField.getText();
                OutlineToolbuttonNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] availableSiblings = ScoutProposalUtility.getSiblingProposals(SdkTypeUtility.getToolbuttons((IType)this.m_declaringType));
        this.m_siblingField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(availableSiblings), "Sibling");
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.setEnabled(availableSiblings != null && availableSiblings.length > 0);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                OutlineToolbuttonNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                OutlineToolbuttonNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_outlineField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        OutlineToolbuttonNewOperation operation = new OutlineToolbuttonNewOperation(this.m_declaringType);
        operation.setTypeName(this.getTypeName());
        ToolbuttonNewWizardPage1 previousPage = (ToolbuttonNewWizardPage1)this.getWizard().getPage(ToolbuttonNewWizardPage1.class.getName());
        if (previousPage.getSuperType() != null) {
            operation.setSuperTypeSignature(Signature.createTypeSignature((String)previousPage.getSuperType().getFullyQualifiedName(), (boolean)true));
        }
        if (this.getOutline() != null) {
            operation.setOutlineType(this.getOutline().getType());
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredOutline((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_TOOL_BUTTON));
        } else {
            operation.setSibling((IJavaElement)this.getSibling().getScoutType());
        }
        operation.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusOutline());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Tool")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusOutline() {
        if (this.getOutline() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "An outline must be selected.");
        }
        return Status.OK_STATUS;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void setOutline(ITypeProposal outline) {
        try {
            this.setStateChanging(true);
            this.m_outline = outline;
            if (this.isControlCreated()) {
                this.m_outlineField.acceptProposal(outline);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getOutline() {
        return this.m_outline;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

