/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.toolbutton;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.ToolbuttonNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.toolbutton.ToolbuttonNewWizardPage1;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ToolbuttonNewWizardPage2
extends AbstractWorkspaceWizardPage {
    final IType iToolbutton = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.tool.IToolButton");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private SiblingProposal m_sibling;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;

    public ToolbuttonNewWizardPage2(IType declaringType) {
        super(ToolbuttonNewWizardPage2.class.getName());
        this.setTitle("New Tool Button");
        this.setDefaultMessage("Create a new tool button.");
        this.m_declaringType = declaringType;
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, SdkTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), "Name");
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    ToolbuttonNewWizardPage2.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (ToolbuttonNewWizardPage2.this.getNlsName() != null) {
                        oldEntry = ToolbuttonNewWizardPage2.this.getNlsName().getNlsEntry();
                    }
                    ToolbuttonNewWizardPage2.this.m_nlsName = (NlsProposal)event.proposal;
                    if (ToolbuttonNewWizardPage2.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(ToolbuttonNewWizardPage2.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)ToolbuttonNewWizardPage2.this.m_typeNameField.getModifiableText()))) {
                        ToolbuttonNewWizardPage2.this.m_typeNameField.setText(ToolbuttonNewWizardPage2.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    ToolbuttonNewWizardPage2.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Tool");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ToolbuttonNewWizardPage2.this.m_typeName = ToolbuttonNewWizardPage2.this.m_typeNameField.getText();
                ToolbuttonNewWizardPage2.this.pingStateChanging();
            }
        });
        IContentProposalEx[] availableSiblings = ScoutProposalUtility.getSiblingProposals(SdkTypeUtility.getToolbuttons((IType)this.m_declaringType));
        this.m_siblingField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(availableSiblings), "Sibling");
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.setEnabled(availableSiblings != null && availableSiblings.length > 0);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                ToolbuttonNewWizardPage2.this.m_sibling = (SiblingProposal)event.proposal;
                ToolbuttonNewWizardPage2.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        ToolbuttonNewOperation operation = new ToolbuttonNewOperation(this.m_declaringType);
        ToolbuttonNewWizardPage1 previousPage = (ToolbuttonNewWizardPage1)this.getWizard().getPage(ToolbuttonNewWizardPage1.class.getName());
        IType superType = previousPage.getSuperType();
        if (superType != null) {
            operation.setSuperTypeSignature(Signature.createTypeSignature((String)superType.getFullyQualifiedName(), (boolean)true));
        }
        operation.setTypeName(this.getTypeName());
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredType((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_TOOL_BUTTON));
        } else {
            operation.setSibling((IJavaElement)this.getSibling().getScoutType());
        }
        operation.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Tool")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

