/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.WizardNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WizardNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iWizard = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizard");
    final IType abstractWizard = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.wizard.AbstractWizard");
    private NlsProposal m_nlsName;
    private String m_typeName;
    private ITypeProposal m_superType;
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private final IScoutBundle m_clientBundle;

    public WizardNewWizardPage(IScoutBundle clientBundle) {
        super("New Wizard");
        this.setTitle("New Wizard");
        this.setDefaultMessage("Create a new wizard.");
        this.m_clientBundle = clientBundle;
        this.m_superType = ScoutProposalUtility.getScoutTypeProposalsFor(this.abstractWizard)[0];
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, null, "Name");
        INlsProject nlsProject = this.getClientBundle().findBestMatchNlsProject();
        if (nlsProject != null) {
            this.m_nlsNameField.setNlsProject(nlsProject);
        } else {
            this.m_nlsNameField.setEnabled(false);
        }
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    WizardNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (WizardNewWizardPage.this.getNlsName() != null) {
                        oldEntry = WizardNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    WizardNewWizardPage.this.m_nlsName = (NlsProposal)event.proposal;
                    if (WizardNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(WizardNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)WizardNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        WizardNewWizardPage.this.m_typeNameField.setText(WizardNewWizardPage.this.m_nlsName.getNlsEntry().getKey());
                    }
                }
                finally {
                    WizardNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Wizard");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardNewWizardPage.this.m_typeName = WizardNewWizardPage.this.m_typeNameField.getText();
                WizardNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(this.abstractWizard);
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(SdkTypeUtility.getAbstractTypesOnClasspath((IType)this.iWizard, (IJavaProject)this.getClientBundle().getJavaProject()));
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(shotList, proposals), "Super Type");
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                WizardNewWizardPage.this.m_superType = (ITypeProposal)event.proposal;
                WizardNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData tablePageData = new GridData(768);
        this.m_nlsNameField.setLayoutData(tablePageData);
        this.m_typeNameField.setLayoutData(tablePageData);
        this.m_superTypeField.setLayoutData(tablePageData);
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        WizardNewOperation m_operation = new WizardNewOperation();
        m_operation.setClientBundle(this.getClientBundle());
        if (this.getNlsName() != null) {
            m_operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        m_operation.setTypeName(this.getTypeName());
        ITypeProposal superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            m_operation.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true));
        }
        m_operation.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Wizard")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (ScoutSdk.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(".ui.wizards")) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public NlsProposal getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public ITypeProposal getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

