/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.wizard.step;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.WizardStepNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.DefaultProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WizardStepNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iWizardStep = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizardStep");
    final IType abstractWizardStep = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStep");
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_SIBLING = "sibling";
    private NlsProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private IType m_createdWizardStep;

    public WizardStepNewWizardPage(IType declaringType) {
        super(WizardStepNewWizardPage.class.getName());
        this.setTitle("New Wizard Step");
        this.setDefaultMessage("Create a new wizard step.");
        this.m_declaringType = declaringType;
        ITypeProposal superType = this.getSuperType();
        if (superType == null) {
            superType = ScoutProposalUtility.getScoutTypeProposalsFor(this.abstractWizardStep)[0];
        }
        this.setSuperTypeInternal(superType);
        this.setSibling(SiblingProposal.SIBLING_END);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, SdkTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), "Name");
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    WizardStepNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    if (WizardStepNewWizardPage.this.getNlsName() != null) {
                        oldEntry = WizardStepNewWizardPage.this.getNlsName().getNlsEntry();
                    }
                    NlsProposal newEntry = (NlsProposal)event.proposal;
                    WizardStepNewWizardPage.this.setNlsNameInternal(newEntry);
                    if (newEntry != null && (oldEntry == null || oldEntry.getKey().equals(WizardStepNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)WizardStepNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        WizardStepNewWizardPage.this.m_typeNameField.setText(newEntry.getNlsEntry().getKey());
                    }
                }
                finally {
                    WizardStepNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, "Type Name");
        this.m_typeNameField.setReadOnlySuffix("Step");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardStepNewWizardPage.this.setTypeNameInternal(WizardStepNewWizardPage.this.m_typeNameField.getText());
                WizardStepNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] shotList = ScoutProposalUtility.getScoutTypeProposalsFor(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStep"));
        IContentProposalEx[] proposals = ScoutProposalUtility.getScoutTypeProposalsFor(SdkTypeUtility.getAbstractTypesOnClasspath((IType)this.iWizardStep, (IJavaProject)this.m_declaringType.getJavaProject()));
        this.m_superTypeField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(shotList, proposals), "Super Type");
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                WizardStepNewWizardPage.this.setSuperTypeInternal((ITypeProposal)event.proposal);
                WizardStepNewWizardPage.this.pingStateChanging();
            }
        });
        IContentProposalEx[] availableSiblings = ScoutProposalUtility.getSiblingProposals(SdkTypeUtility.getWizardSteps((IType)this.m_declaringType));
        this.m_siblingField = this.getFieldToolkit().createProposalField(parent, new DefaultProposalProvider(availableSiblings), "Sibling");
        this.m_siblingField.acceptProposal(this.getSibling());
        this.m_siblingField.setEnabled(availableSiblings != null && availableSiblings.length > 0);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                WizardStepNewWizardPage.this.setSiblingInternal((SiblingProposal)event.proposal);
                WizardStepNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException {
        WizardStepNewOperation operation = new WizardStepNewOperation(this.m_declaringType);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName().getNlsEntry());
        }
        operation.setTypeName(this.getTypeName());
        ITypeProposal superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            operation.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeProp.getType().getFullyQualifiedName(), (boolean)true));
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = SdkTypeUtility.createStructuredWizard((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_WIZARD_STEP));
        } else {
            operation.setSibling((IJavaElement)this.getSibling().getScoutType());
        }
        operation.run(monitor, workingCopyManager);
        this.m_createdWizardStep = operation.getCreatedWizardStep();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Step")) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (this.getTypeName().matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (this.getTypeName().matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk", "The super type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public IType getCreatedWizardStep() {
        return this.m_createdWizardStep;
    }

    public NlsProposal getNlsName() {
        return (NlsProposal)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(NlsProposal nlsName) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(nlsName);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(NlsProposal nlsName) {
        this.setProperty(PROP_NLS_NAME, nlsName);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public ITypeProposal getSuperType() {
        return (ITypeProposal)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(ITypeProposal superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(ITypeProposal superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public SiblingProposal getSibling() {
        return (SiblingProposal)this.getProperty(PROP_SIBLING);
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.setSiblingInternal(sibling);
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSiblingInternal(SiblingProposal sibling) {
        this.setProperty(PROP_SIBLING, sibling);
    }
}

