/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.android.cdt.internal.build.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.sequoyah.android.cdt.build.core.INDKService;
import org.eclipse.sequoyah.android.cdt.build.core.NDKUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class NDKPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text libraryTxt;
    private IProject project = null;

    protected Control createContents(Composite composite) {
        IJavaProject iJavaProject;
        IProjectNature iProjectNature = null;
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IJavaProject) {
            iJavaProject = (IJavaProject)this.getElement();
            this.project = iJavaProject.getProject();
        } else if (iAdaptable instanceof IProject) {
            this.project = (IProject)iAdaptable;
        }
        try {
            iProjectNature = this.project.getNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        iJavaProject = new Composite(composite, 4);
        iJavaProject.setLayoutData((Object)new GridData(4, 4, true, true));
        iJavaProject.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite((Composite)iJavaProject, 4);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        composite2.setLayout((Layout)new GridLayout(6, true));
        Label label = new Label(composite2, 4);
        label.setText("Native Library Name");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.libraryTxt = new Text(composite2, 2052);
        this.libraryTxt.setEditable(true);
        this.libraryTxt.setText(this.getInitialValue(INDKService.libName));
        this.libraryTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (iProjectNature == null) {
            this.libraryTxt.setEnabled(false);
        } else {
            this.libraryTxt.setEnabled(true);
        }
        return iJavaProject;
    }

    private String getInitialValue(QualifiedName qualifiedName) {
        String string = "";
        try {
            if (this.project.getPersistentProperty(qualifiedName) != null) {
                string = this.project.getPersistentProperty(qualifiedName);
            }
        }
        catch (CoreException coreException) {
            string = "";
        }
        return string;
    }

    public void performApply() {
        try {
            if (this.project.getPersistentProperty(INDKService.libName) == null || !this.project.getPersistentProperty(INDKService.libName).equals(this.libraryTxt.getText().trim())) {
                this.project.setPersistentProperty(INDKService.libName, this.libraryTxt.getText().trim());
                NDKUtils.generateAndroidMakeFile((IProject)this.project, (String)this.libraryTxt.getText().trim());
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

