/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.factory;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.common.utilities.exception.ExceptionHandler;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.exception.DeviceExceptionHandler;
import org.eclipse.sequoyah.device.framework.internal.model.DeviceServicesTransitions;
import org.eclipse.sequoyah.device.framework.internal.model.MobileService;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.status.MobileStatusTransition;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ServiceFactory {
    private static final String ELEMENT_SERVICE = "service";
    private static final String ELEMENT_STATUS = "status";
    private static final String ATR_START_ID = "startId";
    private static final String ATR_END_ID = "endId";
    private static final String ATR_HALT_ID = "haltId";
    private static final String ATR_ID = "id";
    private static final String ATR_NAME = "name";
    private static final String ATR_ICON = "icon";
    private static final String ATR_DESCRIPTION = "description";
    private static final String ATR_PROVIDER = "provider";
    private static final String ATR_COPYRIGHT = "copyright";
    private static final String ATR_VERSION = "version";
    private static final String ATR_HANDLER = "handler";
    private static final String ATR_VISIBLE = "visible";
    private static final String ATR_PARALLELIZED = "parallelized";
    private static final String ATR_INTERVAL = "interval";
    private static Map<String, IService> servicesMap = null;

    private static IService createService(IExtension iExtension, String string, IServiceHandler iServiceHandler) throws SequoyahException {
        if (servicesMap == null) {
            ServiceFactory.initServicesMap();
        }
        return servicesMap.get(string);
    }

    private static void initServicesMap() throws SequoyahException {
        servicesMap = new HashMap<String, IService>();
        ServiceFactory.loadServicesExtensions();
        ServiceFactory.loadServicesDefinitions();
    }

    private static void loadServicesDefinitions() {
        Collection collection = PluginUtils.getInstalledExtensions((String)"org.eclipse.sequoyah.device.framework.serviceDefinition");
        for (IExtension iExtension : collection) {
            Object object2;
            String string = iExtension.getUniqueIdentifier();
            String string2 = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_ID);
            DeviceServicesTransitions deviceServicesTransitions = new DeviceServicesTransitions();
            deviceServicesTransitions.setDeviceTypeId(string);
            List list = PluginUtils.getPluginElementList((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ELEMENT_STATUS);
            for (Object object2 : list) {
                String string3 = object2.getAttribute(ATR_START_ID);
                String string4 = object2.getAttribute(ATR_END_ID);
                String string5 = object2.getAttribute(ATR_HALT_ID);
                MobileStatusTransition mobileStatusTransition = new MobileStatusTransition(string3, string4, string5);
                deviceServicesTransitions.addTransitions(mobileStatusTransition);
            }
            object2 = (MobileService)servicesMap.get(string2);
            if (object2 == null) continue;
            ((MobileService)object2).addDeviceTransitions(deviceServicesTransitions);
            Object object3 = null;
            try {
                object3 = (IServiceHandler)PluginUtils.getExecutableAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_HANDLER);
            }
            catch (CoreException coreException) {}
            if (object3 == null) continue;
            object3.setParent(((MobileService)object2).getHandler());
            ((MobileService)object2).setHandler((IServiceHandler)object3);
        }
    }

    private static void loadServicesExtensions() throws SequoyahException {
        Collection collection = PluginUtils.getInstalledExtensions((String)"org.eclipse.sequoyah.device.framework.service");
        for (IExtension iExtension : collection) {
            if (iExtension == null) {
                throw new SequoyahException();
            }
            String string = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_ID);
            MobileService mobileService = new MobileService(string);
            mobileService.setName(PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_NAME));
            String string2 = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_ICON);
            ImageDescriptor imageDescriptor = null;
            try {
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)iExtension.getContributor().getName(), (String)string2);
            }
            catch (Throwable throwable) {
                ExceptionHandler.showException((SequoyahException)DeviceExceptionHandler.exception(202));
            }
            mobileService.setImage(imageDescriptor);
            mobileService.setDescription(PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_DESCRIPTION));
            mobileService.setProvider(PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_PROVIDER));
            mobileService.setCopyright(PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_COPYRIGHT));
            mobileService.setVersion(PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_VERSION));
            mobileService.setVisible(new Boolean(PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_VISIBLE)));
            mobileService.setParallelized(new Boolean(PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_PARALLELIZED)));
            String string3 = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_INTERVAL);
            mobileService.setInterval(string3 != null ? Integer.parseInt(string3) : 0);
            try {
                IServiceHandler iServiceHandler = (IServiceHandler)PluginUtils.getExecutableAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_HANDLER);
                mobileService.setHandler(iServiceHandler);
            }
            catch (CoreException coreException) {
                ExceptionHandler.showException((SequoyahException)DeviceExceptionHandler.exception(202));
            }
            servicesMap.put(string, mobileService);
        }
    }

    public static IService createService(String string) throws SequoyahException {
        return ServiceFactory.createService(null, string, null);
    }

    public static IService createService(IExtension iExtension) throws SequoyahException {
        String string = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_SERVICE, (String)ATR_ID);
        return ServiceFactory.createService(string);
    }
}

