/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sequoyah.localization.editor.StringEditorPlugin;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.AddArrayItemOperation;
import org.eclipse.sequoyah.localization.editor.model.operations.AddArrayItemsOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddArrayItemAction
extends Action {
    private final StringEditorPart stringEditorPart;
    int quantity = 1;
    public static final String ID = "Array Item";

    public AddArrayItemAction(StringEditorPart stringEditorPart) {
        super(Messages.StringEditorPart_AddArrayItemActionName);
        this.stringEditorPart = stringEditorPart;
        this.setImageDescriptor(StringEditorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sequoyah.localization.editor", (String)"icons/string_array_item.png"));
        this.setId(ID);
        this.setDescription(String.valueOf(Messages.AddArrayItemAction_DescriptionPrefix) + ID);
        this.setEnabled(false);
    }

    public void setQuantity(int n) {
        this.quantity = n;
    }

    public boolean isEnabled() {
        StructuredSelection structuredSelection;
        boolean bl = false;
        if (this.stringEditorPart.getEditorViewer() != null && this.stringEditorPart.getEditorViewer().getSelection() != null) {
            structuredSelection = (StructuredSelection)this.stringEditorPart.getEditorViewer().getSelection();
            Object[] objectArray = structuredSelection.toArray();
            bl = objectArray != null && objectArray.length > 0;
        }
        structuredSelection = this.getArraysSelected();
        return bl && structuredSelection != null && ((RowInfo[])structuredSelection).length == 1 && structuredSelection[0] != null;
    }

    private RowInfo[] getArraysSelected() {
        RowInfo[] rowInfoArray = null;
        ArrayList<RowInfo> arrayList = new ArrayList<RowInfo>();
        if (this.stringEditorPart.getEditorViewer() != null && this.stringEditorPart.getEditorViewer().getSelection() != null) {
            StructuredSelection structuredSelection = (StructuredSelection)this.stringEditorPart.getEditorViewer().getSelection();
            Object[] objectArray = structuredSelection.toArray();
            int n = 0;
            while (n < objectArray.length) {
                RowInfo rowInfo = (RowInfo)objectArray[n];
                if (!(rowInfo instanceof RowInfoLeaf)) {
                    this.addArrayIfNotOnListYet(arrayList, (RowInfo)objectArray[n]);
                } else {
                    RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)rowInfo;
                    if (rowInfoLeaf.getParent() != null) {
                        RowInfo rowInfo2 = rowInfoLeaf.getParent();
                        this.addArrayIfNotOnListYet(arrayList, rowInfo2);
                    }
                }
                ++n;
            }
        }
        rowInfoArray = new RowInfo[arrayList.size()];
        rowInfoArray = arrayList.toArray(rowInfoArray);
        return rowInfoArray;
    }

    private void addArrayIfNotOnListYet(ArrayList<RowInfo> arrayList, RowInfo rowInfo) {
        boolean bl = false;
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList.get(n) != null && arrayList.get(n).getKey().equals(rowInfo.getKey())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            arrayList.add(rowInfo);
        }
    }

    private RowInfo[] getSelectedRowInfo() {
        RowInfo[] rowInfoArray = new RowInfo[1];
        if (this.stringEditorPart.getEditorViewer() != null && this.stringEditorPart.getEditorViewer().getSelection() != null) {
            StructuredSelection structuredSelection = (StructuredSelection)this.stringEditorPart.getEditorViewer().getSelection();
            Object[] objectArray = structuredSelection.toArray();
            int n = 0;
            while (n < objectArray.length) {
                RowInfo rowInfo = (RowInfo)objectArray[n];
                if (rowInfo instanceof RowInfoLeaf) {
                    RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)rowInfo;
                    if (rowInfoLeaf.getParent() != null) {
                        rowInfoArray[0] = rowInfoLeaf.getParent();
                    }
                } else {
                    rowInfoArray[0] = (RowInfo)objectArray[n];
                }
                ++n;
            }
        }
        return rowInfoArray;
    }

    public void run() {
        Object object;
        RowInfo[] rowInfoArray = new RowInfo[this.quantity];
        int n = 0;
        while (n < this.quantity) {
            object = this.getSelectedRowInfo();
            rowInfoArray[n] = object[0];
            ++n;
        }
        if (rowInfoArray != null && rowInfoArray[0] != null) {
            if (rowInfoArray.length > 1) {
                AddArrayItemsOperation addArrayItemsOperation = new AddArrayItemsOperation(Messages.StringEditorPart_AddArrayItemOperationName, this.stringEditorPart, rowInfoArray, this.quantity);
                addArrayItemsOperation.addContext(this.stringEditorPart.getUndoContext());
                this.stringEditorPart.executeOperation(addArrayItemsOperation);
            } else {
                String string = rowInfoArray[0].getKey();
                if (rowInfoArray[0] instanceof RowInfo && this.stringEditorPart.getModel().getRow(string) != null) {
                    object = this.stringEditorPart.getModel().getRow(rowInfoArray[0].getKey());
                    AddArrayItemOperation addArrayItemOperation = new AddArrayItemOperation(Messages.StringEditorPart_AddArrayItemOperationName, this.stringEditorPart, (RowInfo)object);
                    addArrayItemOperation.addContext(this.stringEditorPart.getUndoContext());
                    this.stringEditorPart.executeOperation(addArrayItemOperation);
                }
            }
        }
        this.stringEditorPart.refreshButtonsEnabled();
        this.quantity = 1;
    }
}

